"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLatestIndexTemplateVersion = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Retrieves the latest version of index template
 * There are can be multiple index templates across different Kibana spaces,
 * so we get them all and return the latest(greatest) number
 */
const getLatestIndexTemplateVersion = async ({
  esClient,
  name
}) => {
  let latestTemplateVersion;
  try {
    const response = await esClient.indices.getIndexTemplate({
      name
    });
    const versions = response.index_templates.map(template => {
      var _template$index_templ;
      return (_template$index_templ = template.index_template.version) !== null && _template$index_templ !== void 0 ? _template$index_templ : 0;
    });
    latestTemplateVersion = versions.length ? Math.max(...versions) : 0;
  } catch (e) {
    latestTemplateVersion = 0;
  }
  return latestTemplateVersion;
};
exports.getLatestIndexTemplateVersion = getLatestIndexTemplateVersion;