"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrowdstrikeAgentStatusClient = exports.CROWDSTRIKE_STATUS_RESPONSE = exports.CROWDSTRIKE_NETWORK_STATUS = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _constants = require("@kbn/stack-connectors-plugin/common/crowdstrike/constants");
var _lodash = require("lodash");
var _constants2 = require("../../../../../../common/constants");
var _utils = require("../../../../utils");
var _ = require("../../..");
var _types = require("../../../../../../common/endpoint/types");
var _base_agent_status_client = require("../lib/base_agent_status_client");
var _errors = require("../errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CROWDSTRIKE_AGENT_INDEX_PATTERN = `logs-crowdstrike.host-*`;
let CROWDSTRIKE_NETWORK_STATUS = exports.CROWDSTRIKE_NETWORK_STATUS = /*#__PURE__*/function (CROWDSTRIKE_NETWORK_STATUS) {
  CROWDSTRIKE_NETWORK_STATUS["NORMAL"] = "normal";
  CROWDSTRIKE_NETWORK_STATUS["CONTAINED"] = "contained";
  CROWDSTRIKE_NETWORK_STATUS["LIFT_CONTAINMENT_PENDING"] = "lift_containment_pending";
  CROWDSTRIKE_NETWORK_STATUS["CONTAINMENT_PENDING"] = "containment_pending";
  return CROWDSTRIKE_NETWORK_STATUS;
}({});
let CROWDSTRIKE_STATUS_RESPONSE = exports.CROWDSTRIKE_STATUS_RESPONSE = /*#__PURE__*/function (CROWDSTRIKE_STATUS_RESPONSE) {
  CROWDSTRIKE_STATUS_RESPONSE["ONLINE"] = "online";
  CROWDSTRIKE_STATUS_RESPONSE["OFFLINE"] = "offline";
  CROWDSTRIKE_STATUS_RESPONSE["UNKNOWN"] = "unknown";
  return CROWDSTRIKE_STATUS_RESPONSE;
}({});
class CrowdstrikeAgentStatusClient extends _base_agent_status_client.AgentStatusClient {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "agentType", 'crowdstrike');
  }
  async getAgentStatusFromConnectorAction(agentIds) {
    var _agentStatusResponse$;
    const connectorActions = new _.NormalizedExternalConnectorClient(this.options.connectorActionsClient, this.log);
    connectorActions.setup(_constants.CROWDSTRIKE_CONNECTOR_ID);
    const agentStatusResponse = await connectorActions.execute({
      params: {
        subAction: _constants.SUB_ACTION.GET_AGENT_ONLINE_STATUS,
        subActionParams: {
          ids: agentIds
        }
      }
    });
    return (0, _lodash.keyBy)((_agentStatusResponse$ = agentStatusResponse.data) === null || _agentStatusResponse$ === void 0 ? void 0 : _agentStatusResponse$.resources, 'id');
  }
  async getAgentStatuses(agentIds) {
    const esClient = this.options.esClient;
    const metadataService = this.options.endpointService.getEndpointMetadataService();
    const sortField = 'crowdstrike.host.last_seen';
    const query = {
      bool: {
        must: [{
          bool: {
            filter: [{
              terms: {
                'device.id': agentIds
              }
            }]
          }
        }]
      }
    };
    try {
      var _searchResponse$hits, _searchResponse$hits$;
      const [searchResponse, allPendingActions] = await Promise.all([esClient.search({
        index: CROWDSTRIKE_AGENT_INDEX_PATTERN,
        from: 0,
        size: _constants2.DEFAULT_MAX_TABLE_QUERY_SIZE,
        query,
        collapse: {
          field: 'device.id',
          inner_hits: {
            name: 'most_recent',
            size: 1,
            sort: [{
              [sortField]: {
                order: 'desc'
              }
            }]
          }
        },
        sort: [{
          [sortField]: {
            order: 'desc'
          }
        }],
        _source: false
      }, {
        ignore: [404]
      }), (0, _.getPendingActionsSummary)(esClient, metadataService, this.log, agentIds)]).catch(_utils.catchAndWrapError);
      const mostRecentAgentInfosByAgentId = searchResponse === null || searchResponse === void 0 ? void 0 : (_searchResponse$hits = searchResponse.hits) === null || _searchResponse$hits === void 0 ? void 0 : (_searchResponse$hits$ = _searchResponse$hits.hits) === null || _searchResponse$hits$ === void 0 ? void 0 : _searchResponse$hits$.reduce((acc, hit) => {
        var _hit$fields;
        if ((_hit$fields = hit.fields) !== null && _hit$fields !== void 0 && _hit$fields['device.id'][0]) {
          var _hit$fields2, _hit$inner_hits;
          acc[(_hit$fields2 = hit.fields) === null || _hit$fields2 === void 0 ? void 0 : _hit$fields2['device.id'][0]] = (_hit$inner_hits = hit.inner_hits) === null || _hit$inner_hits === void 0 ? void 0 : _hit$inner_hits.most_recent.hits.hits[0]._source;
        }
        return acc;
      }, {});
      const agentStatuses = await this.getAgentStatusFromConnectorAction(agentIds);
      return agentIds.reduce((acc, agentId) => {
        var _pendingActions$pendi;
        const {
          device,
          crowdstrike
        } = mostRecentAgentInfosByAgentId[agentId] || {};
        const agentStatus = agentStatuses[agentId];
        const pendingActions = allPendingActions.find(agentPendingActions => agentPendingActions.agent_id === agentId);
        acc[agentId] = {
          agentId,
          agentType: this.agentType,
          found: (device === null || device === void 0 ? void 0 : device.id) === agentId,
          isolated: (crowdstrike === null || crowdstrike === void 0 ? void 0 : crowdstrike.host.status) === CROWDSTRIKE_NETWORK_STATUS.CONTAINED || (crowdstrike === null || crowdstrike === void 0 ? void 0 : crowdstrike.host.status) === CROWDSTRIKE_NETWORK_STATUS.LIFT_CONTAINMENT_PENDING,
          lastSeen: (crowdstrike === null || crowdstrike === void 0 ? void 0 : crowdstrike.host.last_seen) || (agentStatus === null || agentStatus === void 0 ? void 0 : agentStatus.last_seen) || '',
          status: (agentStatus === null || agentStatus === void 0 ? void 0 : agentStatus.state) === CROWDSTRIKE_STATUS_RESPONSE.ONLINE ? _types.HostStatus.HEALTHY :
          // TODO TC: not sure what the UNKNOWN is - still to be figured
          (agentStatus === null || agentStatus === void 0 ? void 0 : agentStatus.state) === CROWDSTRIKE_STATUS_RESPONSE.UNKNOWN ? _types.HostStatus.OFFLINE : _types.HostStatus.OFFLINE,
          pendingActions: (_pendingActions$pendi = pendingActions === null || pendingActions === void 0 ? void 0 : pendingActions.pending_actions) !== null && _pendingActions$pendi !== void 0 ? _pendingActions$pendi : {}
        };
        return acc;
      }, {});
    } catch (err) {
      const error = new _errors.AgentStatusClientError(`Failed to fetch crowdstrike agent status for agentIds: [${agentIds}], failed with: ${err.message}`, 500, err);
      this.log.error(error);
      throw error;
    }
  }
}
exports.CrowdstrikeAgentStatusClient = CrowdstrikeAgentStatusClient;