"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBuildSuccessReportFromLastMessageNode = void 0;
var _langgraph = require("@langchain/langgraph");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getBuildSuccessReportFromLastMessageNode = () => {
  return async state => {
    const {
      messages,
      validateEsqlResults
    } = state;
    const lastMessage = messages[messages.length - 1];
    const containsInvalidQueries = validateEsqlResults.some(result => !result.isValid);
    if (containsInvalidQueries) {
      throw new Error('Expected all queries to be valid.');
    }
    return new _langgraph.Command({
      update: {
        messages: [`${lastMessage.content}\n\nNote: All queries have been validated against the available data. No need to make any further changes to the queries.`]
      }
    });
  };
};
exports.getBuildSuccessReportFromLastMessageNode = getBuildSuccessReportFromLastMessageNode;