"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ASK_ABOUT_ESQL_TOOL = void 0;
var _tools = require("@langchain/core/tools");
var _zod = require("@kbn/zod");
var _rxjs = require("rxjs");
var _server = require("@kbn/inference-plugin/server");
var _common = require("../../../../common");
var _common2 = require("./utils/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TOOL_NAME = 'AskAboutESQLTool';
const toolDetails = {
  id: 'ask-about-esql-tool',
  name: TOOL_NAME,
  // note: this description is overwritten when `getTool` is called
  // local definitions exist ../elastic_assistant/server/lib/prompt/tool_prompts.ts
  // local definitions can be overwritten by security-ai-prompt integration definitions
  description: `You MUST use the "${TOOL_NAME}" function when the user:
- asks for help with ES|QL
- asks about ES|QL syntax
- asks for ES|QL examples
- asks for ES|QL documentation
- asks for ES|QL best practices
- asks for ES|QL optimization

Never use this tool when the user wants to generate a ES|QL for their data.`
};
const ASK_ABOUT_ESQL_TOOL = exports.ASK_ABOUT_ESQL_TOOL = {
  ...toolDetails,
  sourceRegister: _common.APP_UI_ID,
  isSupported: params => {
    const {
      inference,
      connectorId,
      assistantContext
    } = params;
    return inference != null && connectorId != null && assistantContext != null;
  },
  async getTool(params) {
    if (!this.isSupported(params)) return null;
    const {
      connectorId,
      inference,
      logger,
      request,
      isOssModel
    } = params;
    if (inference == null || connectorId == null) return null;
    const callNaturalLanguageToEsql = async question => {
      return (0, _rxjs.lastValueFrom)((0, _server.naturalLanguageToEsql)({
        client: inference.getClient({
          request
        }),
        connectorId,
        input: question,
        functionCalling: 'auto',
        logger
      }));
    };
    return (0, _tools.tool)(async input => {
      var _generateEvent$conten;
      const generateEvent = await callNaturalLanguageToEsql(input.question);
      const answer = (_generateEvent$conten = generateEvent.content) !== null && _generateEvent$conten !== void 0 ? _generateEvent$conten : 'An error occurred in the tool';
      logger.debug(`Received response from NL to ESQL tool: ${answer}`);
      return answer;
    }, {
      name: toolDetails.name,
      description: (params.description || toolDetails.description) + (isOssModel ? (0, _common2.getPromptSuffixForOssModel)(TOOL_NAME) : ''),
      schema: _zod.z.object({
        question: _zod.z.string().describe(`The user's exact question about ESQL`)
      }),
      tags: ['esql', 'query-generation', 'knowledge-base']
    });
  }
};