"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFileEventsQuery = getFileEventsQuery;
var _constants = require("../../../../../common/endpoint/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SIZE = 200;
function getFileEventsQuery({
  endpointIds
}) {
  return {
    allow_no_indices: true,
    query: {
      bool: {
        must: [{
          terms: {
            'agent.id': endpointIds
          }
        }, {
          range: {
            '@timestamp': {
              gte: 'now-24h',
              lte: 'now'
            }
          }
        }]
      }
    },
    size: 0,
    // Aggregations only
    aggs: {
      unique_process_executable: {
        terms: {
          field: 'process.executable',
          size: SIZE
        },
        aggs: {
          // Get the latest event for each process.executable
          latest_event: {
            top_hits: {
              size: 1,
              sort: [{
                '@timestamp': {
                  order: 'desc'
                }
              }],
              _source: ['_id', 'agent.id', 'process.executable'] // Include only necessary fields
            }
          }
        }
      }
    },
    ignore_unavailable: true,
    index: [_constants.FILE_EVENTS_INDEX_PATTERN]
  };
}