"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddListItemPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _formik = require("formik");
var _securitysolutionListHooks = require("@kbn/securitysolution-list-hooks");
var _use_app_toasts = require("../../common/hooks/use_app_toasts");
var _kibana_react = require("../../common/lib/kibana/kibana_react");
var _translations = require("../translations");
var _telemetry = require("../../common/lib/telemetry");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddListItemPopover = ({
  listId
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const {
    addSuccess,
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const http = (0, _kibana_react.useKibana)().services.http;
  const createListItemMutation = (0, _securitysolutionListHooks.useCreateListItemMutation)({
    onSuccess: () => {
      addSuccess(_translations.SUCCESSFULLY_ADDED_ITEM);
    },
    onError: error => {
      var _error$body$message, _error$body;
      addError(error, {
        title: error.message,
        toastMessage: (_error$body$message = error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : error.message
      });
    }
  });
  const formik = (0, _formik.useFormik)({
    initialValues: {
      value: ''
    },
    validate: values => {
      if (values.value.trim() === '') {
        return {
          value: _translations.VALUE_REQUIRED
        };
      }
    },
    onSubmit: async values => {
      (0, _telemetry.track)(_telemetry.METRIC_TYPE.COUNT, _telemetry.TELEMETRY_EVENT.CREATE_VALUE_LIST_ITEM);
      await createListItemMutation.mutateAsync({
        listId,
        value: values.value,
        http
      });
      setIsPopoverOpen(false);
      formik.resetForm();
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    initialFocus: "#value-list-item-value",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconSide: "right",
      fill: true,
      iconType: "arrowDown",
      "data-test-subj": "value-list-item-add-button-show-popover",
      onClick: () => setIsPopoverOpen(true)
    }, _translations.ADD_LIST_ITEM),
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false)
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 500
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    onSubmit: formik.handleSubmit,
    component: "form"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _translations.VALUE_LABEL,
    id: "value-list-item-value",
    isInvalid: !!formik.errors.value,
    error: [formik.errors.value]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    autoComplete: "off",
    onChange: formik.handleChange,
    value: formik.values.value,
    name: "value",
    icon: "listAdd",
    "data-test-subj": "value-list-item-add-input",
    isInvalid: !!formik.errors.value
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasEmptyLabelSpace: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "value-list-item-add-button-submit",
    isLoading: createListItemMutation.isLoading,
    type: "submit"
  }, createListItemMutation.isLoading ? _translations.ADDING_LIST_ITEM_BUTTON : _translations.ADD_LIST_ITEM_BUTTON)))))));
};
exports.AddListItemPopover = AddListItemPopover;