"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timelineReducer = exports.initialTimelineState = void 0;
var _typescriptFsaReducers = require("typescript-fsa-reducers");
var _actions = require("./actions");
var _helpers = require("./helpers");
var _types = require("./types");
var _timeline = require("../../../common/api/timeline");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialTimelineState = exports.initialTimelineState = {
  timelineById: _types.EMPTY_TIMELINE_BY_ID,
  showCallOutUnauthorizedMsg: false,
  insertTimeline: null
};

/** The reducer for all timeline actions  */
const timelineReducer = exports.timelineReducer = (0, _typescriptFsaReducers.reducerWithInitialState)(initialTimelineState).case(_actions.addTimeline, (state, {
  id,
  timeline,
  resolveTimelineConfig
}) => ({
  ...state,
  timelineById: (0, _helpers.addTimelineToStore)({
    id,
    timeline,
    resolveTimelineConfig,
    timelineById: state.timelineById
  })
})).case(_actions.createTimeline, (state, {
  id,
  timelineType = _timeline.TimelineTypeEnum.default,
  ...timelineProps
}) => {
  return {
    ...state,
    timelineById: (0, _helpers.addNewTimeline)({
      id,
      timelineById: state.timelineById,
      timelineType,
      ...timelineProps
    })
  };
}).case(_actions.addNote, (state, {
  id,
  noteId
}) => ({
  ...state,
  timelineById: (0, _helpers.addTimelineNote)({
    id,
    noteId,
    timelineById: state.timelineById
  })
})).case(_actions.addNoteToEvent, (state, {
  id,
  noteId,
  eventId
}) => ({
  ...state,
  timelineById: (0, _helpers.addTimelineNoteToEvent)({
    id,
    noteId,
    eventId,
    timelineById: state.timelineById
  })
})).case(_actions.addProvider, (state, {
  id,
  providers
}) => ({
  ...state,
  timelineById: (0, _helpers.addTimelineProviders)({
    id,
    providers,
    timelineById: state.timelineById
  })
})).case(_actions.applyKqlFilterQuery, (state, {
  id,
  filterQuery
}) => ({
  ...state,
  timelineById: (0, _helpers.applyKqlFilterQueryDraft)({
    id,
    filterQuery,
    timelineById: state.timelineById
  })
})).case(_actions.showTimeline, (state, {
  id,
  show
}) => ({
  ...state,
  timelineById: (0, _helpers.updateTimelineShowTimeline)({
    id,
    show,
    timelineById: state.timelineById
  })
})).case(_actions.updateGraphEventId, (state, {
  id,
  graphEventId
}) => ({
  ...state,
  timelineById: (0, _helpers.updateTimelineGraphEventId)({
    id,
    graphEventId,
    timelineById: state.timelineById
  })
})).case(_actions.updateSessionViewConfig, (state, {
  id,
  sessionViewConfig
}) => ({
  ...state,
  timelineById: (0, _helpers.updateTimelineSessionViewConfig)({
    id,
    sessionViewConfig,
    timelineById: state.timelineById
  })
})).case(_actions.pinEvent, (state, {
  id,
  eventId
}) => ({
  ...state,
  timelineById: (0, _helpers.pinTimelineEvent)({
    id,
    eventId,
    timelineById: state.timelineById
  })
})).case(_actions.removeProvider, (state, {
  id,
  providerId,
  andProviderId
}) => ({
  ...state,
  timelineById: (0, _helpers.removeTimelineProvider)({
    id,
    providerId,
    timelineById: state.timelineById,
    andProviderId
  })
})).case(_actions.startTimelineSaving, (state, {
  id
}) => ({
  ...state,
  timelineById: {
    ...state.timelineById,
    [id]: {
      ...state.timelineById[id],
      isSaving: true
    }
  }
})).case(_actions.endTimelineSaving, (state, {
  id
}) => ({
  ...state,
  timelineById: {
    ...state.timelineById,
    [id]: {
      ...state.timelineById[id],
      isSaving: false
    }
  }
})).case(_actions.setExcludedRowRendererIds, (state, {
  id,
  excludedRowRendererIds
}) => ({
  ...state,
  timelineById: (0, _helpers.updateExcludedRowRenderersIds)({
    id,
    excludedRowRendererIds,
    timelineById: state.timelineById
  })
})).case(_actions.updateTimeline, (state, {
  id,
  timeline
}) => ({
  ...state,
  timelineById: {
    ...state.timelineById,
    [id]: timeline
  }
})).case(_actions.unPinEvent, (state, {
  id,
  eventId
}) => ({
  ...state,
  timelineById: (0, _helpers.unPinTimelineEvent)({
    id,
    eventId,
    timelineById: state.timelineById
  })
})).case(_actions.updateIsFavorite, (state, {
  id,
  isFavorite
}) => ({
  ...state,
  timelineById: (0, _helpers.updateTimelineIsFavorite)({
    id,
    isFavorite,
    timelineById: state.timelineById
  })
})).case(_actions.updateKqlMode, (state, {
  id,
  kqlMode
}) => ({
  ...state,
  timelineById: (0, _helpers.updateTimelineKqlMode)({
    id,
    kqlMode,
    timelineById: state.timelineById
  })
})).case(_actions.updateTitleAndDescription, (state, {
  id,
  title,
  description
}) => ({
  ...state,
  timelineById: (0, _helpers.updateTimelineTitleAndDescription)({
    id,
    title,
    description,
    timelineById: state.timelineById
  })
})).case(_actions.updateProviders, (state, {
  id,
  providers
}) => ({
  ...state,
  timelineById: (0, _helpers.updateTimelineProviders)({
    id,
    providers,
    timelineById: state.timelineById
  })
})).case(_actions.updateRange, (state, {
  id,
  start,
  end
}) => ({
  ...state,
  timelineById: (0, _helpers.updateTimelineRange)({
    id,
    start,
    end,
    timelineById: state.timelineById
  })
})).case(_actions.updateDataProviderEnabled, (state, {
  id,
  enabled,
  providerId,
  andProviderId
}) => ({
  ...state,
  timelineById: (0, _helpers.updateTimelineProviderEnabled)({
    id,
    enabled,
    providerId,
    timelineById: state.timelineById,
    andProviderId
  })
})).case(_actions.updateDataProviderExcluded, (state, {
  id,
  excluded,
  providerId,
  andProviderId
}) => ({
  ...state,
  timelineById: (0, _helpers.updateTimelineProviderExcluded)({
    id,
    excluded,
    providerId,
    timelineById: state.timelineById,
    andProviderId
  })
})).case(_actions.dataProviderEdited, (state, {
  andProviderId,
  excluded,
  field,
  id,
  operator,
  providerId,
  value
}) => ({
  ...state,
  timelineById: (0, _helpers.updateTimelineProviderProperties)({
    andProviderId,
    excluded,
    field,
    id,
    operator,
    providerId,
    timelineById: state.timelineById,
    value
  })
})).case(_actions.updateDataProviderType, (state, {
  id,
  type,
  providerId,
  andProviderId
}) => ({
  ...state,
  timelineById: (0, _helpers.updateTimelineProviderType)({
    id,
    type,
    providerId,
    timelineById: state.timelineById,
    andProviderId
  })
})).case(_actions.showCallOutUnauthorizedMsg, state => ({
  ...state,
  showCallOutUnauthorizedMsg: true
})).case(_actions.setSavedQueryId, (state, {
  id,
  savedQueryId
}) => ({
  ...state,
  timelineById: (0, _helpers.updateSavedQuery)({
    id,
    savedQueryId,
    timelineById: state.timelineById
  })
})).case(_actions.setFilters, (state, {
  id,
  filters
}) => ({
  ...state,
  timelineById: (0, _helpers.updateFilters)({
    id,
    filters,
    timelineById: state.timelineById
  })
})).case(_actions.setInsertTimeline, (state, insertTimeline) => ({
  ...state,
  insertTimeline
})).case(_actions.updateDataView, (state, {
  id,
  dataViewId,
  indexNames
}) => ({
  ...state,
  timelineById: {
    ...state.timelineById,
    [id]: {
      ...state.timelineById[id],
      dataViewId,
      indexNames
    }
  }
})).case(_actions.setActiveTabTimeline, (state, {
  id,
  activeTab,
  scrollToTop
}) => ({
  ...state,
  timelineById: {
    ...state.timelineById,
    [id]: {
      ...state.timelineById[id],
      activeTab,
      prevActiveTab: state.timelineById[id].activeTab,
      scrollToTop: scrollToTop ? {
        timestamp: Math.floor(Date.now() / 1000) // convert to seconds to avoid unnecessary rerenders for multiple clicks
      } : undefined
    }
  }
})).case(_actions.toggleModalSaveTimeline, (state, {
  id,
  showModalSaveTimeline
}) => ({
  ...state,
  timelineById: {
    ...state.timelineById,
    [id]: {
      ...state.timelineById[id],
      showSaveModal: showModalSaveTimeline
    }
  }
})).case(_actions.updateEqlOptions, (state, {
  id,
  field,
  value
}) => {
  var _state$timelineById$i;
  return {
    ...state,
    timelineById: {
      ...state.timelineById,
      [id]: {
        ...state.timelineById[id],
        eqlOptions: {
          ...((_state$timelineById$i = state.timelineById[id].eqlOptions) !== null && _state$timelineById$i !== void 0 ? _state$timelineById$i : {}),
          [field]: value
        }
      }
    }
  };
}).case(_actions.setEventsLoading, (state, {
  id,
  eventIds,
  isLoading
}) => ({
  ...state,
  timelineById: (0, _helpers.setLoadingTableEvents)({
    id,
    eventIds,
    timelineById: state.timelineById,
    isLoading
  })
})).case(_actions.removeColumn, (state, {
  id,
  columnId
}) => ({
  ...state,
  timelineById: (0, _helpers.removeTimelineColumn)({
    id,
    columnId,
    timelineById: state.timelineById
  })
})).case(_actions.upsertColumn, (state, {
  column,
  id,
  index
}) => ({
  ...state,
  timelineById: (0, _helpers.upsertTimelineColumn)({
    column,
    id,
    index,
    timelineById: state.timelineById
  })
})).case(_actions.updateColumns, (state, {
  id,
  columns
}) => ({
  ...state,
  timelineById: (0, _helpers.updateTimelineColumns)({
    id,
    columns,
    timelineById: state.timelineById
  })
})).case(_actions.updateSort, (state, {
  id,
  sort
}) => ({
  ...state,
  timelineById: (0, _helpers.updateTimelineSort)({
    id,
    sort,
    timelineById: state.timelineById
  })
})).case(_actions.setSelected, (state, {
  id,
  eventIds,
  isSelected,
  isSelectAllChecked
}) => ({
  ...state,
  timelineById: (0, _helpers.setSelectedTableEvents)({
    id,
    eventIds,
    timelineById: state.timelineById,
    isSelected,
    isSelectAllChecked
  })
})).case(_actions.clearSelected, (state, {
  id
}) => ({
  ...state,
  timelineById: {
    ...state.timelineById,
    [id]: {
      ...state.timelineById[id],
      selectedEventIds: {},
      isSelectAllChecked: false
    }
  }
})).case(_actions.setEventsDeleted, (state, {
  id,
  eventIds,
  isDeleted
}) => ({
  ...state,
  timelineById: (0, _helpers.setDeletedTableEvents)({
    id,
    eventIds,
    timelineById: state.timelineById,
    isDeleted
  })
})).case(_actions.initializeTimelineSettings, (state, {
  id,
  ...timelineSettingsProps
}) => ({
  ...state,
  timelineById: (0, _helpers.setInitializeTimelineSettings)({
    id,
    timelineById: state.timelineById,
    timelineSettingsProps
  })
})).case(_actions.updateItemsPerPage, (state, {
  id,
  itemsPerPage
}) => ({
  ...state,
  timelineById: (0, _helpers.updateTimelineItemsPerPage)({
    id,
    itemsPerPage,
    timelineById: state.timelineById
  })
})).case(_actions.updateItemsPerPageOptions, (state, {
  id,
  itemsPerPageOptions
}) => ({
  ...state,
  timelineById: (0, _helpers.updateTimelinePerPageOptions)({
    id,
    itemsPerPageOptions,
    timelineById: state.timelineById
  })
})).case(_actions.clearEventsDeleted, (state, {
  id
}) => ({
  ...state,
  timelineById: {
    ...state.timelineById,
    [id]: {
      ...state.timelineById[id],
      deletedEventIds: []
    }
  }
})).case(_actions.clearEventsLoading, (state, {
  id
}) => ({
  ...state,
  timelineById: {
    ...state.timelineById,
    [id]: {
      ...state.timelineById[id],
      loadingEventIds: []
    }
  }
})).case(_actions.updateSavedSearchId, (state, {
  id,
  savedSearchId
}) => ({
  ...state,
  timelineById: {
    ...state.timelineById,
    [id]: {
      ...state.timelineById[id],
      savedSearchId
    }
  }
})).case(_actions.initializeSavedSearch, (state, {
  id,
  savedSearch
}) => ({
  ...state,
  timelineById: {
    ...state.timelineById,
    [id]: {
      ...state.timelineById[id],
      savedSearch
    }
  }
})).case(_actions.updateSavedSearch, (state, {
  id,
  savedSearch
}) => ({
  ...state,
  timelineById: {
    ...state.timelineById,
    [id]: {
      ...state.timelineById[id],
      savedSearch
    }
  }
})).case(_actions.setDataProviderVisibility, (state, {
  id,
  isDataProviderVisible
}) => {
  return {
    ...state,
    timelineById: {
      ...state.timelineById,
      [id]: {
        ...state.timelineById[id],
        isDataProviderVisible
      }
    }
  };
}).case(_actions.setChanged, (state, {
  id,
  changed
}) => ({
  ...state,
  timelineById: {
    ...state.timelineById,
    [id]: {
      ...state.timelineById[id],
      changed
    }
  }
})).case(_actions.updateColumnWidth, (state, {
  id,
  columnId,
  width
}) => ({
  ...state,
  timelineById: (0, _helpers.updateTimelineColumnWidth)({
    columnId,
    id,
    timelineById: state.timelineById,
    width
  })
})).case(_actions.updateSampleSize, (state, {
  id,
  sampleSize
}) => ({
  ...state,
  timelineById: {
    ...state.timelineById,
    [id]: {
      ...state.timelineById[id],
      sampleSize
    }
  }
})).case(_actions.updateRowHeight, (state, {
  id,
  rowHeight
}) => ({
  ...state,
  timelineById: {
    ...state.timelineById,
    [id]: {
      ...state.timelineById[id],
      rowHeight
    }
  }
})).case(_actions.setConfirmingNoteId, (state, {
  id,
  confirmingNoteId
}) => ({
  ...state,
  timelineById: {
    ...state.timelineById,
    [id]: {
      ...state.timelineById[id],
      confirmingNoteId
    }
  }
})).case(_actions.deleteNoteFromEvent, (state, {
  id,
  noteId,
  eventId
}) => ({
  ...state,
  timelineById: {
    ...state.timelineById,
    [id]: {
      ...state.timelineById[id],
      eventIdToNoteIds: {
        ...state.timelineById[id].eventIdToNoteIds,
        [eventId]: state.timelineById[id].eventIdToNoteIds[eventId].filter(note => note !== noteId)
      }
    }
  }
})).build();