"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultCellRenderer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _get_mapped_non_ecs_value = require("../../../../common/utils/get_mapped_non_ecs_value");
var _renderers = require("../body/renderers");
var _get_column_renderer = require("../body/renderers/get_column_renderer");
var _helpers = require("../../../../common/lib/cell_actions/helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledContent = _styledComponents.default.div`
  padding: ${({
  $isDetails
}) => $isDetails ? '0 8px' : undefined};
  width: 100%;
  margin: 0 auto;
`;
const DefaultCellRenderer = ({
  data,
  ecsData,
  eventId,
  header,
  isDetails,
  isTimeline,
  linkValues,
  rowRenderers,
  scopeId,
  truncate,
  asPlainText,
  context
}) => {
  const asPlainTextDefault = (0, _react.useMemo)(() => {
    return (0, _helpers.getLinkColumnDefinition)(header.id, header.type, header.linkField) !== undefined && !isTimeline;
  }, [header.id, header.linkField, header.type, isTimeline]);
  const values = (0, _get_mapped_non_ecs_value.useGetMappedNonEcsValue)({
    data,
    fieldName: header.id
  });
  const styledContentClassName = isDetails ? 'eui-textBreakWord' : 'eui-displayInlineBlock eui-textTruncate';
  return /*#__PURE__*/_react.default.createElement(StyledContent, {
    className: styledContentClassName,
    $isDetails: isDetails
  }, (0, _get_column_renderer.getColumnRenderer)(header.id, _renderers.columnRenderers, data, context).renderColumn({
    asPlainText: asPlainText !== null && asPlainText !== void 0 ? asPlainText : asPlainTextDefault,
    // we want to render value with links as plain text but keep other formatters like badge. Except rule name for non preview tables
    columnName: header.id,
    ecsData,
    eventId,
    field: header,
    isDetails,
    linkValues,
    rowRenderers,
    scopeId,
    truncate,
    values,
    context
  }));
};
exports.DefaultCellRenderer = DefaultCellRenderer;