"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnifiedTimelineBody = void 0;
var _react = _interopRequireWildcard(require("react"));
var _domDragDrop = require("@kbn/dom-drag-drop");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _use_data_view = require("../../../../data_view_manager/hooks/use_data_view");
var _use_get_sourcerer_data_view = require("../../../../sourcerer/components/use_get_sourcerer_data_view");
var _data_view_error = require("../../../../common/components/data_view_error");
var _styles = require("../unified_components/styles");
var _unified_components = require("../unified_components");
var _default_headers = require("./column_headers/default_headers");
var _model = require("../../../../sourcerer/store/model");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UnifiedTimelineBody = props => {
  const {
    header,
    isSortEnabled,
    columns,
    rowRenderers,
    timelineId,
    itemsPerPage,
    itemsPerPageOptions,
    sort,
    events,
    refetch,
    dataLoadingState,
    totalCount,
    onFetchMoreRecords,
    activeTab,
    updatedAt,
    trailingControlColumns,
    leadingControlColumns,
    onUpdatePageIndex
  } = props;
  const oldDataView = (0, _use_get_sourcerer_data_view.useGetScopedSourcererDataView)({
    sourcererScope: _model.SourcererScopeName.timeline
  });
  const columnsHeader = (0, _react.useMemo)(() => columns !== null && columns !== void 0 ? columns : _default_headers.defaultUdtHeaders, [columns]);
  const {
    dataView: experimentalDataView
  } = (0, _use_data_view.useDataView)(_model.SourcererScopeName.timeline);
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const dataView = newDataViewPickerEnabled ? experimentalDataView : oldDataView;
  return /*#__PURE__*/_react.default.createElement(_styles.StyledTableFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_styles.StyledUnifiedTableFlexItem, {
    grow: false
  }, header), /*#__PURE__*/_react.default.createElement(_styles.StyledUnifiedTableFlexItem, {
    className: "unifiedTimelineBody",
    "data-test-subj": "unifiedTimelineBody"
  }, /*#__PURE__*/_react.default.createElement(_domDragDrop.RootDragDropProvider, null, dataView ? /*#__PURE__*/_react.default.createElement(_unified_components.UnifiedTimeline, {
    columns: columnsHeader,
    dataView: dataView,
    rowRenderers: rowRenderers,
    isSortEnabled: isSortEnabled,
    timelineId: timelineId,
    itemsPerPage: itemsPerPage,
    itemsPerPageOptions: itemsPerPageOptions,
    sort: sort,
    events: events,
    refetch: refetch,
    dataLoadingState: dataLoadingState,
    totalCount: totalCount,
    onFetchMoreRecords: onFetchMoreRecords,
    activeTab: activeTab,
    updatedAt: updatedAt,
    isTextBasedQuery: false,
    trailingControlColumns: trailingControlColumns,
    leadingControlColumns: leadingControlColumns,
    onUpdatePageIndex: onUpdatePageIndex
  }) : /*#__PURE__*/_react.default.createElement(_data_view_error.DataViewErrorComponent, null))));
};
exports.UnifiedTimelineBody = UnifiedTimelineBody;