"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.whoisRenderer = exports.reputationRenderer = exports.locationRenderer = exports.hostNameRenderer = exports.hostIdRenderer = exports.autonomousSystemRenderer = exports.IpOverviewId = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _draggables = require("../../../common/components/draggables");
var _empty_value = require("../../../common/components/empty_value");
var _links = require("../../../common/components/links");
var i18n = _interopRequireWildcard(require("../../../explore/network/components/details/translations"));
var _flyout_link = require("../../../flyout/shared/components/flyout_link");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IpOverviewId = exports.IpOverviewId = 'ip-overview';
const locationRenderer = (fieldNames, data, contextID) => fieldNames.length > 0 && fieldNames.every(fieldName => (0, _fp.getOr)(null, fieldName, data)) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  gutterSize: "none"
}, fieldNames.map((fieldName, index) => {
  const locationValue = (0, _fp.getOr)('', fieldName, data);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: `${IpOverviewId}-${fieldName}`
  }, index ? ',\u00A0' : '', /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
    id: `location-renderer-default-draggable-${IpOverviewId}-${contextID ? `${contextID}-` : ''}${fieldName}`,
    field: fieldName,
    value: locationValue,
    isAggregatable: true,
    fieldType: 'keyword'
  })));
})) : (0, _empty_value.getEmptyTagValue)();
exports.locationRenderer = locationRenderer;
const autonomousSystemRenderer = (as, flowTarget, contextID) => as && as.organization && as.organization.name && as.number ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  gutterSize: "none"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
  id: `autonomous-system-renderer-default-draggable-${IpOverviewId}-${contextID ? `${contextID}-` : ''}${flowTarget}.as.organization.name`,
  field: `${flowTarget}.as.organization.name`,
  value: as.organization.name
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, '/'), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
  id: `autonomous-system-renderer-default-draggable-${IpOverviewId}-${contextID ? `${contextID}-` : ''}${flowTarget}.as.number`,
  field: `${flowTarget}.as.number`,
  value: `${as.number}`,
  isAggregatable: true,
  fieldType: 'number'
}))) : (0, _empty_value.getEmptyTagValue)();
exports.autonomousSystemRenderer = autonomousSystemRenderer;
const hostIdRenderer = ({
  contextID,
  host,
  ipFilter,
  noLink,
  scopeId,
  isFlyoutOpen
}) => host.id && host.ip && (ipFilter == null || host.ip.includes(ipFilter)) ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, host.name && host.name[0] != null ? /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
  id: `host-id-renderer-default-draggable-${IpOverviewId}-${contextID ? `${contextID}-` : ''}host-id`,
  field: "host.id",
  value: host.id[0],
  isAggregatable: true,
  fieldType: 'keyword',
  scopeId: scopeId
}, noLink ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, host.id) : /*#__PURE__*/_react.default.createElement(_flyout_link.FlyoutLink, {
  field: 'host.name',
  value: host.name[0],
  scopeId: scopeId,
  isFlyoutOpen: isFlyoutOpen
}, host.id)) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, host.id)) : (0, _empty_value.getEmptyTagValue)();
exports.hostIdRenderer = hostIdRenderer;
const hostNameRenderer = ({
  scopeId,
  host,
  ipFilter,
  contextID,
  isFlyoutOpen
}) => host.name && host.name[0] && host.ip && (!(ipFilter != null) || host.ip.includes(ipFilter)) ? /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
  id: `host-name-renderer-default-draggable-${IpOverviewId}-${contextID ? `${contextID}-` : ''}host-name`,
  field: 'host.name',
  value: host.name[0],
  isAggregatable: true,
  fieldType: 'keyword',
  scopeId: scopeId
}, /*#__PURE__*/_react.default.createElement(_flyout_link.FlyoutLink, {
  field: 'host.name',
  value: host.name[0],
  scopeId: scopeId,
  isFlyoutOpen: isFlyoutOpen
})) : (0, _empty_value.getEmptyTagValue)();
exports.hostNameRenderer = hostNameRenderer;
const whoisRenderer = ip => /*#__PURE__*/_react.default.createElement(_links.WhoIsLink, {
  domain: ip
}, i18n.VIEW_WHOIS);
exports.whoisRenderer = whoisRenderer;
const reputationRenderer = ip => /*#__PURE__*/_react.default.createElement(_links.ReputationLink, {
  domain: ip,
  direction: "column"
});
exports.reputationRenderer = reputationRenderer;