"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SiemRulesMigrationsTelemetry = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _siem_migrations = require("../../../common/lib/telemetry/events/siem_migrations");
var _types = require("../../../common/lib/telemetry/events/siem_migrations/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SiemRulesMigrationsTelemetry {
  constructor(telemetryService) {
    (0, _defineProperty2.default)(this, "getBaseResultParams", error => ({
      result: error ? 'failed' : 'success',
      ...(error && {
        errorMessage: error.message
      })
    }));
    // Setup actions
    (0, _defineProperty2.default)(this, "reportConnectorSelected", params => {
      this.telemetryService.reportEvent(_types.SiemMigrationsEventTypes.SetupConnectorSelected, {
        eventName: _siem_migrations.siemMigrationEventNames[_types.SiemMigrationsEventTypes.SetupConnectorSelected],
        connectorId: params.connector.id,
        connectorType: params.connector.actionTypeId
      });
    });
    (0, _defineProperty2.default)(this, "reportSetupMigrationOpen", params => {
      this.telemetryService.reportEvent(_types.SiemMigrationsEventTypes.SetupMigrationOpenNew, {
        eventName: _siem_migrations.siemMigrationEventNames[_types.SiemMigrationsEventTypes.SetupMigrationOpenNew],
        ...params
      });
    });
    (0, _defineProperty2.default)(this, "reportSetupMigrationOpenResources", params => {
      this.telemetryService.reportEvent(_types.SiemMigrationsEventTypes.SetupMigrationOpenResources, {
        eventName: _siem_migrations.siemMigrationEventNames[_types.SiemMigrationsEventTypes.SetupMigrationOpenResources],
        ...params
      });
    });
    (0, _defineProperty2.default)(this, "reportSetupMigrationCreated", params => {
      const {
        migrationId,
        rulesCount,
        error
      } = params;
      this.telemetryService.reportEvent(_types.SiemMigrationsEventTypes.SetupMigrationCreated, {
        eventName: _siem_migrations.siemMigrationEventNames[_types.SiemMigrationsEventTypes.SetupMigrationCreated],
        migrationId,
        rulesCount,
        ...this.getBaseResultParams(error)
      });
    });
    (0, _defineProperty2.default)(this, "reportSetupMigrationDeleted", params => {
      const {
        migrationId,
        error
      } = params;
      this.telemetryService.reportEvent(_types.SiemMigrationsEventTypes.SetupMigrationDeleted, {
        eventName: _siem_migrations.siemMigrationEventNames[_types.SiemMigrationsEventTypes.SetupMigrationDeleted],
        migrationId,
        ...this.getBaseResultParams(error)
      });
    });
    (0, _defineProperty2.default)(this, "reportSetupResourceUploaded", params => {
      const {
        migrationId,
        type,
        count,
        error
      } = params;
      this.telemetryService.reportEvent(_types.SiemMigrationsEventTypes.SetupResourcesUploaded, {
        eventName: _siem_migrations.siemMigrationEventNames[_types.SiemMigrationsEventTypes.SetupResourcesUploaded],
        migrationId,
        count,
        type,
        ...this.getBaseResultParams(error)
      });
    });
    (0, _defineProperty2.default)(this, "reportSetupRulesQueryCopied", params => {
      const {
        migrationId
      } = params;
      this.telemetryService.reportEvent(_types.SiemMigrationsEventTypes.SetupRulesQueryCopied, {
        migrationId,
        eventName: _siem_migrations.siemMigrationEventNames[_types.SiemMigrationsEventTypes.SetupRulesQueryCopied]
      });
    });
    (0, _defineProperty2.default)(this, "reportSetupMacrosQueryCopied", params => {
      this.telemetryService.reportEvent(_types.SiemMigrationsEventTypes.SetupMacrosQueryCopied, {
        eventName: _siem_migrations.siemMigrationEventNames[_types.SiemMigrationsEventTypes.SetupMacrosQueryCopied],
        ...params
      });
    });
    (0, _defineProperty2.default)(this, "reportSetupLookupNameCopied", params => {
      this.telemetryService.reportEvent(_types.SiemMigrationsEventTypes.SetupLookupNameCopied, {
        eventName: _siem_migrations.siemMigrationEventNames[_types.SiemMigrationsEventTypes.SetupLookupNameCopied],
        ...params
      });
    });
    (0, _defineProperty2.default)(this, "reportStartTranslation", params => {
      const {
        migrationId,
        settings: {
          connectorId,
          skipPrebuiltRulesMatching = false
        },
        retry,
        error
      } = params;
      this.telemetryService.reportEvent(_types.SiemMigrationsEventTypes.StartMigration, {
        migrationId,
        connectorId,
        isRetry: !!retry,
        skipPrebuiltRulesMatching,
        eventName: _siem_migrations.siemMigrationEventNames[_types.SiemMigrationsEventTypes.StartMigration],
        ...(retry && {
          retryFilter: retry
        }),
        ...this.getBaseResultParams(error)
      });
    });
    (0, _defineProperty2.default)(this, "reportStopTranslation", params => {
      const {
        migrationId,
        error
      } = params;
      this.telemetryService.reportEvent(_types.SiemMigrationsEventTypes.StopMigration, {
        migrationId,
        eventName: _siem_migrations.siemMigrationEventNames[_types.SiemMigrationsEventTypes.StopMigration],
        ...this.getBaseResultParams(error)
      });
    });
    // Translated rule actions
    (0, _defineProperty2.default)(this, "reportTranslatedRuleUpdate", params => {
      const {
        migrationRule,
        error
      } = params;
      this.telemetryService.reportEvent(_types.SiemMigrationsEventTypes.TranslatedRuleUpdate, {
        eventName: _siem_migrations.siemMigrationEventNames[_types.SiemMigrationsEventTypes.TranslatedRuleUpdate],
        migrationId: migrationRule.migration_id,
        ruleMigrationId: migrationRule.id,
        ...this.getBaseResultParams(error)
      });
    });
    (0, _defineProperty2.default)(this, "reportTranslatedRuleInstall", params => {
      var _migrationRule$elasti;
      const {
        migrationRule,
        enabled,
        error
      } = params;
      const eventParams = {
        eventName: _siem_migrations.siemMigrationEventNames[_types.SiemMigrationsEventTypes.TranslatedRuleInstall],
        migrationId: migrationRule.migration_id,
        ruleMigrationId: migrationRule.id,
        author: 'custom',
        enabled,
        ...this.getBaseResultParams(error)
      };
      if ((_migrationRule$elasti = migrationRule.elastic_rule) !== null && _migrationRule$elasti !== void 0 && _migrationRule$elasti.prebuilt_rule_id) {
        eventParams.author = 'elastic';
        eventParams.prebuiltRule = {
          id: migrationRule.elastic_rule.prebuilt_rule_id,
          title: migrationRule.elastic_rule.title
        };
      }
      this.telemetryService.reportEvent(_types.SiemMigrationsEventTypes.TranslatedRuleInstall, eventParams);
    });
    (0, _defineProperty2.default)(this, "reportTranslatedRuleBulkInstall", params => {
      const {
        migrationId,
        count,
        enabled,
        error
      } = params;
      this.telemetryService.reportEvent(_types.SiemMigrationsEventTypes.TranslatedRuleBulkInstall, {
        eventName: _siem_migrations.siemMigrationEventNames[_types.SiemMigrationsEventTypes.TranslatedRuleBulkInstall],
        migrationId,
        count,
        enabled,
        ...this.getBaseResultParams(error)
      });
    });
    this.telemetryService = telemetryService;
  }
}
exports.SiemRulesMigrationsTelemetry = SiemRulesMigrationsTelemetry;