"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNoConnectorToast = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../../../onboarding/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getNoConnectorToast = core => ({
  color: 'danger',
  iconType: 'alert',
  title: _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rulesService.noConnector.title', {
    defaultMessage: 'No connector configured.'
  }),
  text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_securitySolutionNavigation.NavigationProvider, {
    core: core
  }, /*#__PURE__*/_react.default.createElement(NoConnectorToastContent, null)), core)
});
exports.getNoConnectorToast = getNoConnectorToast;
const navigation = {
  deepLinkId: _securitySolutionNavigation.SecurityPageName.landing,
  path: `${_constants.OnboardingTopicId.siemMigrations}#${_constants.OnboardingCardId.siemMigrationsAiConnectors}`
};
const NoConnectorToastContent = () => {
  const {
    navigateTo,
    getAppUrl
  } = (0, _securitySolutionNavigation.useNavigation)();
  const onClick = ev => {
    ev.preventDefault();
    navigateTo(navigation);
  };
  const url = getAppUrl(navigation);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "flexStart",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.siemMigrations.rulesService.noConnector.text",
    defaultMessage: "No AI connector configured. Select an AI connector to start rule translations."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: onClick,
    href: url
  }, _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rulesService.noConnector.link', {
    defaultMessage: 'Go to connector selection'
  }))));
};