"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UPDATE_MIGRATION_RULES_FAILURE = exports.UPDATE_MIGRATION_NAME_SUCCESS = exports.UPDATE_MIGRATION_NAME_FAILURE = exports.RETRY_FAILED_RULES_FAILURE = exports.INSTALL_MIGRATION_RULES_SUCCESS = exports.INSTALL_MIGRATION_RULES_FAILURE = exports.GET_MIGRATION_TRANSLATION_STATS_FAILURE = exports.GET_MIGRATION_RULES_FAILURE = exports.GET_MIGRATION_PREBUILT_RULES_FAILURE = exports.DELETE_MIGRATION_SUCCESS = exports.DELETE_MIGRATION_FAILURE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GET_MIGRATION_PREBUILT_RULES_FAILURE = exports.GET_MIGRATION_PREBUILT_RULES_FAILURE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.getMigrationPrebuiltRulesFailDescription', {
  defaultMessage: 'Failed to fetch prebuilt rules'
});
const GET_MIGRATION_RULES_FAILURE = exports.GET_MIGRATION_RULES_FAILURE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.getMigrationRulesFailDescription', {
  defaultMessage: 'Failed to fetch migration rules'
});
const GET_MIGRATION_TRANSLATION_STATS_FAILURE = exports.GET_MIGRATION_TRANSLATION_STATS_FAILURE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.getMigrationTranslationStatsFailDescription', {
  defaultMessage: 'Failed to fetch migration translation stats'
});
const INSTALL_MIGRATION_RULES_SUCCESS = succeeded => _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.installMigrationRulesSuccess', {
  defaultMessage: '{succeeded, plural, one {# rule} other {# rules}} installed successfully.',
  values: {
    succeeded
  }
});
exports.INSTALL_MIGRATION_RULES_SUCCESS = INSTALL_MIGRATION_RULES_SUCCESS;
const INSTALL_MIGRATION_RULES_FAILURE = exports.INSTALL_MIGRATION_RULES_FAILURE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.installMigrationRulesFailDescription', {
  defaultMessage: 'Failed to install migration rules'
});
const UPDATE_MIGRATION_RULES_FAILURE = exports.UPDATE_MIGRATION_RULES_FAILURE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.updateMigrationRulesFailDescription', {
  defaultMessage: 'Failed to update migration rules'
});
const RETRY_FAILED_RULES_FAILURE = exports.RETRY_FAILED_RULES_FAILURE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.retryFailedRulesFailDescription', {
  defaultMessage: 'Failed to reprocess migration rules'
});
const UPDATE_MIGRATION_NAME_SUCCESS = exports.UPDATE_MIGRATION_NAME_SUCCESS = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.updateMigrationNameSuccess', {
  defaultMessage: 'Migration name updated'
});
const UPDATE_MIGRATION_NAME_FAILURE = exports.UPDATE_MIGRATION_NAME_FAILURE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.updateMigrationNameFailDescription', {
  defaultMessage: 'Failed to update migration name'
});
const DELETE_MIGRATION_SUCCESS = exports.DELETE_MIGRATION_SUCCESS = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.deleteMigrationSuccess', {
  defaultMessage: 'Migration deleted'
});
const DELETE_MIGRATION_FAILURE = exports.DELETE_MIGRATION_FAILURE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.deleteMigrationFailDescription', {
  defaultMessage: 'Failed to delete migration'
});