"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tourSteps = exports.tourConfig = exports.TourSteps = exports.SECURITY_GET_STARTED_BUTTON_ANCHOR = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _doc_link = require("../../../../../common/components/links_to_docs/doc_link");
var _constants = require("../../../../../../common/constants");
var _header_buttons = require("../../header_buttons");
var _rules_table_columns = require("../../rules_table_columns");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SECURITY_GET_STARTED_BUTTON_ANCHOR = exports.SECURITY_GET_STARTED_BUTTON_ANCHOR = `solutionSideNavCustomIconItem-${_constants.SecurityPageName.landing}`;
let TourSteps = exports.TourSteps = /*#__PURE__*/function (TourSteps) {
  TourSteps[TourSteps["MIGRATION_SELECTION"] = 0] = "MIGRATION_SELECTION";
  TourSteps[TourSteps["MIGRATION_RULE_STATUS"] = 1] = "MIGRATION_RULE_STATUS";
  TourSteps[TourSteps["MIGRATION_ONBOARDING_HUB"] = 2] = "MIGRATION_ONBOARDING_HUB";
  return TourSteps;
}({});
const tourSteps = exports.tourSteps = {
  [TourSteps.MIGRATION_SELECTION]: {
    step: 1,
    title: i18n.MIGRATION_RULES_SELECTOR_TOUR_STEP_TITLE,
    content: i18n.MIGRATION_RULES_SELECTOR_TOUR_STEP_CONTENT,
    anchorId: _header_buttons.SIEM_MIGRATIONS_SELECT_MIGRATION_BUTTON_ID,
    anchorPosition: 'downCenter'
  },
  [TourSteps.MIGRATION_RULE_STATUS]: {
    step: 2,
    title: i18n.TRANSLATION_STATUS_TOUR_STEP_TITLE,
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.siemMigrations.rules.tour.statusStepContent",
      defaultMessage: "{installed} rules have a check mark. Click {view} to access rule details. {translated} rules are ready to {install}, or for your to {edit}. Rules with errors can be {reprocessed}. {lineBreak}{lineBreak} Learn more about our {link}",
      values: {
        lineBreak: /*#__PURE__*/_react.default.createElement("br", null),
        install: /*#__PURE__*/_react.default.createElement("b", null, i18n.INSTALL_LABEL),
        installed: /*#__PURE__*/_react.default.createElement("b", null, i18n.INSTALLED_LABEL),
        view: /*#__PURE__*/_react.default.createElement("b", null, i18n.VIEW_LABEL),
        edit: /*#__PURE__*/_react.default.createElement("b", null, i18n.EDIT_LABEL),
        translated: /*#__PURE__*/_react.default.createElement("b", null, i18n.TRANSLATED_LABEL),
        reprocessed: /*#__PURE__*/_react.default.createElement("b", null, i18n.REPROCESSED_LABEL),
        // TODO: Update doc path once available
        link: /*#__PURE__*/_react.default.createElement(_doc_link.DocLink, {
          docPath: "index.html",
          linkText: i18n.SIEM_MIGRATIONS_LINK_LABEL
        })
      }
    }),
    anchorId: _rules_table_columns.SIEM_MIGRATIONS_STATUS_HEADER_ID,
    anchorPosition: 'rightCenter'
  },
  [TourSteps.MIGRATION_ONBOARDING_HUB]: {
    step: 3,
    title: i18n.MIGRATION_GUIDE_TOUR_STEP_TITLE,
    content: i18n.MIGRATION_GUIDE_TOUR_STEP_CONTENT,
    anchorId: SECURITY_GET_STARTED_BUTTON_ANCHOR,
    anchorPosition: 'rightCenter'
  }
};
const tourConfig = exports.tourConfig = {
  currentTourStep: tourSteps[TourSteps.MIGRATION_SELECTION].step,
  isTourActive: true,
  tourPopoverWidth: 360
};