"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertFilterOptions = void 0;
var _types = require("../../../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AUTHOR_FILTERS = {
  [_types.AuthorFilter.ELASTIC]: {
    prebuilt: true
  },
  [_types.AuthorFilter.CUSTOM]: {
    prebuilt: false
  }
};
const STATUS_FILTERS = {
  [_types.StatusFilter.FAILED]: {
    failed: true
  },
  [_types.StatusFilter.INSTALLED]: {
    installed: true
  },
  [_types.StatusFilter.TRANSLATED]: {
    installed: false,
    fullyTranslated: true
  },
  [_types.StatusFilter.PARTIALLY_TRANSLATED]: {
    partiallyTranslated: true
  },
  [_types.StatusFilter.UNTRANSLATABLE]: {
    untranslatable: true
  }
};
const convertFilterOptions = filterOptions => {
  const filters = {};
  if (filterOptions !== null && filterOptions !== void 0 && filterOptions.author) {
    Object.assign(filters, AUTHOR_FILTERS[filterOptions.author]);
  }
  if (filterOptions !== null && filterOptions !== void 0 && filterOptions.status) {
    Object.assign(filters, STATUS_FILTERS[filterOptions.status]);
  }
  return filters;
};
exports.convertFilterOptions = convertFilterOptions;