"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReprocessFailedRulesButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
var _missing_privileges = require("../../missing_privileges");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ReprocessFailedRulesButtonComp = /*#__PURE__*/_react.default.memo(function ReprocessFailedRulesButton({
  onClick,
  isLoading = false,
  numberOfFailedRules = 0,
  isDisabled = false,
  isAuthorized
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "refresh",
    color: 'warning',
    onClick: onClick,
    disabled: isDisabled || !isAuthorized,
    isLoading: isLoading,
    "data-test-subj": "reprocessFailedRulesButton",
    "aria-label": i18n.REPROCESS_FAILED_ARIA_LABEL
  }, i18n.REPROCESS_FAILED_RULES(numberOfFailedRules));
});
const ReprocessFailedRulesButton = exports.ReprocessFailedRulesButton = (0, _missing_privileges.WithMissingPrivilegesTooltip)(ReprocessFailedRulesButtonComp, 'all');