"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TabContentPadding = exports.MigrationRuleDetailsFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _css = require("@emotion/css");
var _uiTheme = require("@kbn/ui-theme");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../common/siem_migrations/constants");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _rule_overview_tab = require("../../../../detection_engine/rule_management/components/rule_details/rule_overview_tab");
var logicI18n = _interopRequireWildcard(require("../../logic/translations"));
var i18n = _interopRequireWildcard(require("./translations"));
var _constants2 = require("./constants");
var _tabs = require("./tabs");
var _utils = require("../../../../../common/siem_migrations/rules/utils");
var _use_update_migration_rule = require("../../logic/use_update_migration_rule");
var _updated_by = require("./updated_by");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Fixes tabs to the top and allows the content to scroll.
 */
const ScrollableFlyoutTabbedContent = props => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column",
  gutterSize: "none"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: true
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, props)));
const tabPaddingClassName = (0, _css.css)`
  padding: 0 ${_uiTheme.euiThemeVars.euiSizeM} ${_uiTheme.euiThemeVars.euiSizeXL} ${_uiTheme.euiThemeVars.euiSizeM};
`;
const TabContentPadding = ({
  children
}) => /*#__PURE__*/_react.default.createElement("div", {
  className: tabPaddingClassName
}, children);
exports.TabContentPadding = TabContentPadding;
const MigrationRuleDetailsFlyout = exports.MigrationRuleDetailsFlyout = /*#__PURE__*/_react.default.memo(({
  ruleActions,
  migrationRule,
  matchedPrebuiltRule,
  size = 'm',
  extraTabs = [],
  isDataLoading,
  closeFlyout
}) => {
  var _tabs$find, _ref, _ruleDetailsToOvervie;
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    expandedOverviewSections,
    toggleOverviewSection
  } = (0, _rule_overview_tab.useOverviewTabSections)();
  const {
    mutateAsync: updateMigrationRule
  } = (0, _use_update_migration_rule.useUpdateMigrationRule)(migrationRule);
  const [isUpdating, setIsUpdating] = (0, _react.useState)(false);
  const isLoading = isDataLoading || isUpdating;
  const handleTranslationUpdate = (0, _react.useCallback)(async (ruleName, ruleQuery) => {
    if (isLoading) {
      return;
    }
    setIsUpdating(true);
    try {
      await updateMigrationRule({
        id: migrationRule.id,
        elastic_rule: {
          title: ruleName,
          query: ruleQuery,
          query_language: 'esql'
        }
      });
    } catch (error) {
      addError(error, {
        title: logicI18n.UPDATE_MIGRATION_RULES_FAILURE
      });
    } finally {
      setIsUpdating(false);
    }
  }, [isLoading, updateMigrationRule, migrationRule, addError]);
  const ruleDetailsToOverview = (0, _react.useMemo)(() => {
    const elasticRule = migrationRule === null || migrationRule === void 0 ? void 0 : migrationRule.elastic_rule;
    if ((0, _utils.isMigrationCustomRule)(elasticRule)) {
      return (0, _utils.convertMigrationCustomRuleToSecurityRulePayload)(elasticRule, false);
    }
    return matchedPrebuiltRule;
  }, [migrationRule, matchedPrebuiltRule]);
  const translationTab = (0, _react.useMemo)(() => ({
    id: 'translation',
    name: i18n.TRANSLATION_TAB_LABEL,
    content: /*#__PURE__*/_react.default.createElement(TabContentPadding, null, /*#__PURE__*/_react.default.createElement(_tabs.TranslationTab, {
      migrationRule: migrationRule,
      matchedPrebuiltRule: matchedPrebuiltRule,
      onTranslationUpdate: handleTranslationUpdate
    }))
  }), [migrationRule, handleTranslationUpdate, matchedPrebuiltRule]);
  const overviewTab = (0, _react.useMemo)(() => ({
    id: 'overview',
    name: i18n.OVERVIEW_TAB_LABEL,
    content: /*#__PURE__*/_react.default.createElement(TabContentPadding, null, ruleDetailsToOverview && /*#__PURE__*/_react.default.createElement(_rule_overview_tab.RuleOverviewTab, {
      rule: ruleDetailsToOverview,
      columnWidths: size === 'l' ? _constants2.LARGE_DESCRIPTION_LIST_COLUMN_WIDTHS : _constants2.DEFAULT_DESCRIPTION_LIST_COLUMN_WIDTHS,
      expandedOverviewSections: expandedOverviewSections,
      toggleOverviewSection: toggleOverviewSection
    })),
    disabled: migrationRule.translation_result === _constants.RuleTranslationResult.UNTRANSLATABLE
  }), [ruleDetailsToOverview, size, expandedOverviewSections, toggleOverviewSection, migrationRule.translation_result]);
  const summaryTab = (0, _react.useMemo)(() => ({
    id: 'summary',
    name: i18n.SUMMARY_TAB_LABEL,
    content: /*#__PURE__*/_react.default.createElement(TabContentPadding, null, /*#__PURE__*/_react.default.createElement(_tabs.SummaryTab, {
      migrationRule: migrationRule
    }))
  }), [migrationRule]);
  const tabs = (0, _react.useMemo)(() => {
    return [...extraTabs, translationTab, overviewTab, summaryTab];
  }, [extraTabs, translationTab, overviewTab, summaryTab]);
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)(tabs[0].id);
  const selectedTab = (_tabs$find = tabs.find(tab => tab.id === selectedTabId)) !== null && _tabs$find !== void 0 ? _tabs$find : tabs[0];
  (0, _react.useEffect)(() => {
    if (!tabs.find(tab => tab.id === selectedTabId)) {
      // Switch to first tab if currently selected tab is not available for this rule
      setSelectedTabId(tabs[0].id);
    }
  }, [tabs, selectedTabId]);
  const onTabClick = tab => {
    setSelectedTabId(tab.id);
  };
  const tabsContent = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(ScrollableFlyoutTabbedContent, {
      tabs: tabs,
      selectedTab: selectedTab,
      onTabClick: onTabClick
    });
  }, [selectedTab, tabs]);
  const migrationsRulesFlyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'migrationRulesFlyoutTitle'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    size: size,
    onClose: closeFlyout,
    key: "migrations-rules-flyout",
    paddingSize: "l",
    "data-test-subj": "ruleMigrationDetailsFlyout",
    "aria-labelledby": migrationsRulesFlyoutTitleId,
    ownFocus: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: migrationsRulesFlyoutTitleId
  }, (_ref = (_ruleDetailsToOvervie = ruleDetailsToOverview === null || ruleDetailsToOverview === void 0 ? void 0 : ruleDetailsToOverview.name) !== null && _ruleDetailsToOvervie !== void 0 ? _ruleDetailsToOvervie : migrationRule.original_rule.title) !== null && _ref !== void 0 ? _ref : i18n.UNKNOWN_MIGRATION_RULE_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_updated_by.UpdatedByLabel, {
    migrationRule: migrationRule
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody
  // EUI TODO: We need to set transform to 'none' to avoid drag/drop issues in the flyout caused by the
  // `transform: translateZ(0)` workaround for the mask image bug in Chromium.
  // https://github.com/elastic/eui/pull/7855.
  // We need to remove this workaround once it is fixed in EUI:
  // https://github.com/elastic/eui/issues/8269.
  , {
    css: {
      '.euiFlyoutBody__overflow': {
        transform: 'none'
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonLoading, {
    isLoading: isLoading,
    loadingContent: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonTitle, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, null)),
    loadedContent: tabsContent
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeFlyout,
    flush: "left"
  }, i18n.CLOSE_BUTTON_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, ruleActions))));
});
MigrationRuleDetailsFlyout.displayName = 'MigrationRuleDetailsFlyout';