"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LookupsDataInputSubSteps = exports.LookupsDataInput = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _kibana_react = require("../../../../../../common/lib/kibana/kibana_react");
var _get_status = require("../common/get_status");
var i18n = _interopRequireWildcard(require("./translations"));
var _constants = require("../constants");
var _sub_step = require("../common/sub_step");
var _missing_lookups_list = require("./sub_steps/missing_lookups_list");
var _lookups_file_upload = require("./sub_steps/lookups_file_upload");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LookupsDataInput = exports.LookupsDataInput = /*#__PURE__*/_react.default.memo(({
  dataInputStep,
  migrationStats,
  missingLookups,
  onAllLookupsCreated
}) => {
  const dataInputStatus = (0, _react.useMemo)(() => (0, _get_status.getStatus)(_constants.DataInputStep.Lookups, dataInputStep), [dataInputStep]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "center",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStepNumber, {
    titleSize: "xs",
    number: _constants.DataInputStep.Lookups,
    status: dataInputStatus
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("b", null, i18n.LOOKUPS_DATA_INPUT_TITLE))))), dataInputStatus === 'current' && migrationStats && missingLookups && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, i18n.LOOKUPS_DATA_INPUT_DESCRIPTION)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(LookupsDataInputSubSteps, {
    migrationStats: migrationStats,
    missingLookups: missingLookups,
    onAllLookupsCreated: onAllLookupsCreated
  })))));
});
LookupsDataInput.displayName = 'LookupsDataInput';
const END = 10;
const LookupsDataInputSubSteps = exports.LookupsDataInputSubSteps = /*#__PURE__*/_react.default.memo(({
  migrationStats,
  missingLookups,
  onAllLookupsCreated
}) => {
  const {
    telemetry
  } = (0, _kibana_react.useKibana)().services.siemMigrations.rules;
  const [subStep, setSubStep] = (0, _react.useState)(1);
  const [uploadedLookups, setUploadedLookups] = (0, _react.useState)({});
  const addUploadedLookups = (0, _react.useCallback)(lookups => {
    setUploadedLookups(prevUploadedLookups => ({
      ...prevUploadedLookups,
      ...Object.fromEntries(lookups.map(lookup => [lookup.name, lookup.content]))
    }));
  }, []);
  (0, _react.useEffect)(() => {
    if (missingLookups.every(lookupName => uploadedLookups[lookupName] != null)) {
      setSubStep(END);
      onAllLookupsCreated();
    }
  }, [uploadedLookups, missingLookups, onAllLookupsCreated]);

  // Copy query step
  const onCopied = (0, _react.useCallback)(() => {
    setSubStep(2);
    telemetry.reportSetupLookupNameCopied({
      migrationId: migrationStats.id
    });
  }, [telemetry, migrationStats.id]);
  const copyStep = (0, _missing_lookups_list.useMissingLookupsListStep)({
    status: (0, _get_status.getStatus)(1, subStep),
    migrationStats,
    missingLookups,
    uploadedLookups,
    addUploadedLookups,
    onCopied
  });

  // Upload macros step
  const uploadStep = (0, _lookups_file_upload.useLookupsFileUploadStep)({
    status: (0, _get_status.getStatus)(2, subStep),
    migrationStats,
    missingLookups,
    addUploadedLookups
  });
  const steps = (0, _react.useMemo)(() => [copyStep, uploadStep], [copyStep, uploadStep]);
  return /*#__PURE__*/_react.default.createElement(_sub_step.SubSteps, {
    steps: steps
  });
});
LookupsDataInputSubSteps.displayName = 'LookupsDataInputActive';