"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSyncSelectedNode = useSyncSelectedNode;
var _react = require("react");
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var selectors = _interopRequireWildcard(require("../store/selectors"));
var _side_effect_context = require("./side_effect_context");
var _panel_view_and_parameters = require("../store/panel_view_and_parameters");
var _actions = require("../store/actions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This custom hook, will maintain the state of the active/selected node with the what the selected nodeID is in url state.
 * This means page refreshes, direct links, back and forward buttons, should always pan to the node defined in the url
 * In the scenario where the nodeList is visible in the panel, there is no selectedNode, but this would naturally default to the origin node based on `serverReturnedResolverData` on initial load and refresh
 * This custom hook should only be called once on resolver load, following that the url nodeID should always equal the selectedNode.  This is currently called in `resolver_without_providers.tsx`.
 */
function useSyncSelectedNode({
  id
}) {
  const dispatch = (0, _reactRedux.useDispatch)();
  const resolverComponentInstanceID = id;
  const locationSearch = (0, _reactRouterDom.useLocation)().search;
  const sideEffectors = (0, _react.useContext)(_side_effect_context.SideEffectContext);
  const selectedNode = (0, _reactRedux.useSelector)(state => selectors.selectedNode(state.analyzer[id]));
  const idToNodeMap = (0, _reactRedux.useSelector)(state => selectors.graphNodeForID(state.analyzer[id]));
  const currentPanelParameters = (0, _panel_view_and_parameters.panelViewAndParameters)({
    locationSearch,
    resolverComponentInstanceID
  });
  let urlNodeID;
  if (currentPanelParameters.panelView !== 'nodes') {
    urlNodeID = currentPanelParameters.panelParameters.nodeID;
  }
  (0, _react.useEffect)(() => {
    // use this for the entire render in order to keep things in sync
    if (urlNodeID && idToNodeMap(urlNodeID) && urlNodeID !== selectedNode) {
      dispatch((0, _actions.userSelectedResolverNode)({
        id,
        nodeID: urlNodeID,
        time: sideEffectors.timestamp()
      }));
    }
  }, [currentPanelParameters.panelView, urlNodeID, dispatch, idToNodeMap, selectedNode, sideEffectors, id]);
}