"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFormattedDate = useFormattedDate;
var _i18n = require("@kbn/i18n");
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const invalidDateText = _i18n.i18n.translate('xpack.securitySolution.enpdoint.resolver.panelutils.invaliddate', {
  defaultMessage: 'Invalid Date'
});

/**
 * Long formatter (to second) for DateTime
 */
const formatter = new Intl.DateTimeFormat(_i18n.i18n.getLocale(), {
  year: 'numeric',
  month: '2-digit',
  day: '2-digit',
  hour: '2-digit',
  minute: '2-digit',
  second: '2-digit'
});

/**
 *
 * @description formats a given time based on the user defined format in the advanced settings section of kibana under dateFormat
 * @export
 * @param {(ConstructorParameters<typeof Date>[0] | undefined)} timestamp
 * @returns {(string | null)} - Either a formatted date or the text 'Invalid Date'
 */
function useFormattedDate(timestamp) {
  const dateFormatSetting = (0, _public.useUiSetting)('dateFormat');
  const timezoneSetting = (0, _public.useUiSetting)('dateFormat:tz');
  const usableTimezoneSetting = timezoneSetting === 'Browser' ? _momentTimezone.default.tz.guess() : timezoneSetting;
  if (!timestamp) return undefined;
  const date = new Date(timestamp);
  if (date && Number.isFinite(date.getTime())) {
    return dateFormatSetting ? _momentTimezone.default.tz(date, usableTimezoneSetting).format(dateFormatSetting) : formatter.format(date);
  }
  return invalidDateText;
}