"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAllTiDataSources = void 0;
var _react = require("react");
var _use_ti_data_sources = require("./use_ti_data_sources");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAllTiDataSources = () => {
  const {
    to,
    from
  } = (0, _react.useMemo)(() => ({
    to: new Date().toISOString(),
    from: new Date(0).toISOString()
  }), []);
  const {
    tiDataSources,
    isInitiallyLoaded
  } = (0, _use_ti_data_sources.useTiDataSources)({
    to,
    from
  });
  return {
    tiDataSources,
    isInitiallyLoaded
  };
};
exports.useAllTiDataSources = useAllTiDataSources;