"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OnboardingFooter = exports.FooterLinkItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _onboarding_footer = require("./onboarding_footer.styles");
var _footer_items = require("./footer_items");
var _constants = require("./constants");
var _onboarding_context = require("../onboarding_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OnboardingFooter = exports.OnboardingFooter = /*#__PURE__*/_react.default.memo(() => {
  const styles = (0, _onboarding_footer.useFooterStyles)();
  const footerItems = (0, _footer_items.useFooterItems)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    className: styles
  }, footerItems.map(({
    id,
    title,
    icon,
    description,
    link
  }) => /*#__PURE__*/_react.default.createElement(FooterLinkItem, {
    id: id,
    key: `footer-${id}`,
    title: title,
    icon: icon,
    description: description,
    link: link
  })));
});
OnboardingFooter.displayName = 'OnboardingFooter';
const FooterLinkItem = exports.FooterLinkItem = /*#__PURE__*/_react.default.memo(({
  id,
  title,
  icon,
  description,
  link
}) => {
  const {
    telemetry: {
      reportLinkClick
    }
  } = (0, _onboarding_context.useOnboardingContext)();
  const onClickWithReport = (0, _react.useCallback)(() => {
    reportLinkClick === null || reportLinkClick === void 0 ? void 0 : reportLinkClick(`${_constants.TELEMETRY_FOOTER_LINK}_${id}`);
  }, [id, reportLinkClick]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "plain",
    grow: false,
    borderRadius: "m",
    paddingSize: "none",
    hasBorder: true,
    className: "itemPanel"
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "itemIconWrapper"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: icon,
    className: "itemIcon"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    className: "itemTitle"
  }, /*#__PURE__*/_react.default.createElement("h3", null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, description), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "footerLinkItem",
    onClick: onClickWithReport,
    href: link.href,
    target: "_blank"
  }, link.title))));
});
FooterLinkItem.displayName = 'FooterLinkItem';