"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withReportCardLinkClick = exports.CardLinkButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _links = require("../../../../../common/components/links");
var _onboarding_context = require("../../../onboarding_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const withReportCardLinkClick = WrappedComponent => /*#__PURE__*/_react.default.memo(function WithReportCardLinkClick({
  onClick,
  cardId,
  linkId,
  ...rest
}) {
  const {
    telemetry
  } = (0, _onboarding_context.useOnboardingContext)();
  const onClickWithReport = (0, _react.useCallback)(ev => {
    telemetry.reportCardLinkClicked(cardId, linkId);
    onClick === null || onClick === void 0 ? void 0 : onClick(ev);
  }, [telemetry, cardId, linkId, onClick]);
  return /*#__PURE__*/_react.default.createElement(WrappedComponent, (0, _extends2.default)({
    onClick: onClickWithReport
  }, rest));
});
exports.withReportCardLinkClick = withReportCardLinkClick;
const CardLinkButton = exports.CardLinkButton = withReportCardLinkClick(_links.SecuritySolutionLinkButton);
CardLinkButton.displayName = 'CardLinkButton';