"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.routes = void 0;
var _react = _interopRequireDefault(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _note_management_page = require("./pages/note_management_page");
var _ = require("../app/404");
var _constants = require("../../common/constants");
var _plugin_template_wrapper = require("../common/components/plugin_template_wrapper");
var _security_route_page_wrapper = require("../common/components/security_route_page_wrapper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NotesManagementWrapper = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, null, /*#__PURE__*/_react.default.createElement(_note_management_page.NoteManagementPage, null));
const NotesManagementContainer = /*#__PURE__*/_react.default.memo(() => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.NOTES_PATH,
    exact: true,
    component: NotesManagementWrapper
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    component: _.NotFoundPage
  }));
});
NotesManagementContainer.displayName = 'NotesManagementContainer';
const routes = exports.routes = [{
  path: _constants.NOTES_PATH,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(NotesManagementContainer, _constants.SecurityPageName.notes)
}];