"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteNoteButtonIcon = exports.DELETE_NOTE_ERROR = exports.DELETE_NOTE = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _test_ids = require("./test_ids");
var _notes = require("../store/notes.slice");
var _use_app_toasts = require("../../common/hooks/use_app_toasts");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DELETE_NOTE = exports.DELETE_NOTE = _i18n.i18n.translate('xpack.securitySolution.notes.deleteNote.buttonLabel', {
  defaultMessage: 'Delete note'
});
const DELETE_NOTE_ERROR = exports.DELETE_NOTE_ERROR = _i18n.i18n.translate('xpack.securitySolution.notes.deleteNote.errorLabel', {
  defaultMessage: 'Error deleting note'
});
/**
 * Renders a button to delete a note.
 * This button works in combination with the DeleteConfirmModal.
 */
const DeleteNoteButtonIcon = exports.DeleteNoteButtonIcon = /*#__PURE__*/(0, _react.memo)(({
  note,
  index
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    addError: addErrorToast
  } = (0, _use_app_toasts.useAppToasts)();
  const deleteStatus = (0, _reactRedux.useSelector)(state => (0, _notes.selectDeleteNotesStatus)(state));
  const deleteError = (0, _reactRedux.useSelector)(state => (0, _notes.selectDeleteNotesError)(state));
  const [deletingNoteId, setDeletingNoteId] = (0, _react.useState)('');
  const deleteNoteFc = (0, _react.useCallback)(noteId => {
    dispatch((0, _notes.userSelectedNotesForDeletion)(noteId));
    setDeletingNoteId(noteId);
  }, [dispatch]);
  (0, _react.useEffect)(() => {
    if (deleteStatus === _notes.ReqStatus.Failed && deleteError) {
      addErrorToast(null, {
        title: DELETE_NOTE_ERROR
      });
    }
  }, [addErrorToast, deleteError, deleteStatus]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": `${_test_ids.DELETE_NOTE_BUTTON_TEST_ID}-${index}`,
    title: DELETE_NOTE,
    "aria-label": DELETE_NOTE,
    color: "text",
    iconType: "trash",
    onClick: () => deleteNoteFc(note.noteId),
    disabled: deletingNoteId !== note.noteId && deleteStatus === _notes.ReqStatus.Loading,
    isLoading: deletingNoteId === note.noteId && deleteStatus === _notes.ReqStatus.Loading
  });
});
DeleteNoteButtonIcon.displayName = 'DeleteNoteButtonIcon';