"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogicalConditionBuilder = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _condition_group = require("../condition_group");
var _use_test_id_generator = require("../../../../../hooks/use_test_id_generator");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogicalConditionBuilder = exports.LogicalConditionBuilder = /*#__PURE__*/(0, _react.memo)(({
  entries,
  os,
  className,
  isAndDisabled = false,
  onAndClicked,
  onEntryRemove,
  onEntryChange,
  onVisited,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": dataTestSubj,
    className: className
  }, /*#__PURE__*/_react.default.createElement("div", null, entries.length === 0 ? /*#__PURE__*/_react.default.createElement(NoEntries, null) : /*#__PURE__*/_react.default.createElement(_condition_group.ConditionGroup, {
    os: os,
    entries: entries,
    onEntryRemove: onEntryRemove,
    onEntryChange: onEntryChange,
    onAndClicked: onAndClicked,
    isAndDisabled: isAndDisabled,
    onVisited: onVisited,
    "data-test-subj": getTestId('group1')
  })));
});
LogicalConditionBuilder.displayName = 'LogicalConditionBuilder';
const NoEntries = /*#__PURE__*/(0, _react.memo)(() => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "center",
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.trustedapps.logicalConditionBuilder.noEntries",
    defaultMessage: "No conditions defined"
  })));
});
NoEntries.displayName = 'NoEntries';