"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TRUSTED_APPS_LABELS = exports.HOST_ISOLATION_EXCEPTIONS_LABELS = exports.EVENT_FILTERS_LABELS = exports.BLOCKLISTS_LABELS = void 0;
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BLOCKLISTS_LABELS = exports.BLOCKLISTS_LABELS = {
  artifactsSummaryApiError: error => _i18n.i18n.translate('xpack.securitySolution.endpoint.fleetIntegrationCard.blocklistsSummary.error', {
    defaultMessage: 'There was an error trying to fetch blocklist stats: "{error}"',
    values: {
      error
    }
  }),
  cardTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.blocklist.fleetIntegration.title",
    defaultMessage: "Blocklist"
  }),
  linkLabel: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.fleetIntegrationCard.blocklistsManageLabel",
    defaultMessage: "Manage blocklist"
  })
};
const HOST_ISOLATION_EXCEPTIONS_LABELS = exports.HOST_ISOLATION_EXCEPTIONS_LABELS = {
  artifactsSummaryApiError: error => _i18n.i18n.translate('xpack.securitySolution.endpoint.fleetIntegrationCard.hostIsolationExceptionsSummary.error', {
    defaultMessage: 'There was an error trying to fetch host isolation exceptions stats: "{error}"',
    values: {
      error
    }
  }),
  cardTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.hostIsolationExceptions.fleetIntegration.title",
    defaultMessage: "Host isolation exceptions"
  }),
  linkLabel: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.fleetIntegrationCard.hostIsolationExceptionsManageLabel",
    defaultMessage: "Manage host isolation exceptions"
  })
};
const EVENT_FILTERS_LABELS = exports.EVENT_FILTERS_LABELS = {
  artifactsSummaryApiError: error => _i18n.i18n.translate('xpack.securitySolution.endpoint.fleetIntegrationCard.eventFiltersSummary.error', {
    defaultMessage: 'There was an error trying to fetch event filters stats: "{error}"',
    values: {
      error
    }
  }),
  cardTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.eventFilters.fleetIntegration.title",
    defaultMessage: "Event filters"
  }),
  linkLabel: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.fleetIntegrationCard.eventFiltersManageLabel",
    defaultMessage: "Manage event filters"
  })
};
const TRUSTED_APPS_LABELS = exports.TRUSTED_APPS_LABELS = {
  artifactsSummaryApiError: error => _i18n.i18n.translate('xpack.securitySolution.endpoint.fleetIntegrationCard.trustedAppsSummary.error', {
    defaultMessage: 'There was an error trying to fetch trusted apps stats: "{error}"',
    values: {
      error
    }
  }),
  cardTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.trustedApps.fleetIntegration.title",
    defaultMessage: "Trusted applications"
  }),
  linkLabel: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.fleetIntegrationCard.trustedAppsManageLabel",
    defaultMessage: "Manage trusted applications"
  })
};