"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomScriptSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_get_custom_scripts = require("../../../hooks/custom_scripts/use_get_custom_scripts");
var _kibana = require("../../../../common/lib/kibana");
var _use_custom_scripts_error_toast = require("./use_custom_scripts_error_toast");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Css to have a tooltip in place with a one line truncated description
const truncationStyle = (0, _react2.css)({
  display: '-webkit-box',
  overflow: 'hidden',
  WebkitBoxOrient: 'vertical',
  WebkitLineClamp: 1,
  lineClamp: 1,
  // standardized fallback for modern Firefox
  textOverflow: 'ellipsis',
  whiteSpace: 'normal'
});
const INITIAL_DISPLAY_LABEL = _i18n.i18n.translate('xpack.securitySolution.consoleArgumentSelectors.customScriptSelector.initialDisplayLabel', {
  defaultMessage: 'Click to select script'
});
const TOOLTIP_TEXT = _i18n.i18n.translate('xpack.securitySolution.consoleArgumentSelectors.customScriptSelector.tooltipText', {
  defaultMessage: 'Click to choose script'
});

/**
 * State for the custom script selector component
 */

const CustomScriptSelector = exports.CustomScriptSelector = /*#__PURE__*/(0, _react.memo)(({
  value,
  valueText,
  onChange,
  store: _store,
  command,
  requestFocus
}) => {
  var _command$commandDefin;
  // Extract agentType from command.meta instead of direct parameter
  const agentType = (_command$commandDefin = command.commandDefinition.meta) === null || _command$commandDefin === void 0 ? void 0 : _command$commandDefin.agentType;
  const {
    services: {
      notifications
    }
  } = (0, _kibana.useKibana)();
  const state = (0, _react.useMemo)(() => {
    return _store !== null && _store !== void 0 ? _store : {
      isPopoverOpen: !value
    };
  }, [_store, value]);
  const setIsPopoverOpen = (0, _react.useCallback)(newValue => {
    onChange({
      value,
      valueText,
      store: {
        ...state,
        isPopoverOpen: newValue
      }
    });
  }, [onChange, state, value, valueText]);
  const {
    data = [],
    isLoading: isLoadingScripts,
    error: scriptsError
  } = (0, _use_get_custom_scripts.useGetCustomScripts)(agentType);
  const scriptsOptions = (0, _react.useMemo)(() => {
    return data.map(script => {
      const isChecked = script.name === value;
      return {
        label: script.name,
        description: script.description,
        checked: isChecked ? 'on' : undefined
      };
    });
  }, [data, value]);

  // There is a race condition between the parent input and search input which results in search having the last char of the argument eg. 'e' from '--CloudFile'
  // This is a workaround to ensure the popover is not shown until the input is focused
  const [isAwaitingRenderDelay, setIsAwaitingRenderDelay] = (0, _react.useState)(true);
  (0, _react.useEffect)(() => {
    const timer = setTimeout(() => {
      setIsAwaitingRenderDelay(false);
    }, 0);
    return () => clearTimeout(timer);
  }, []);
  const renderOption = option => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      css: truncationStyle
    }, /*#__PURE__*/_react.default.createElement("strong", {
      "data-test-subj": `${option.label}-label`
    }, option.label)), (option === null || option === void 0 ? void 0 : option.description) && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "right",
      content: option.description
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      "data-test-subj": `${option.label}-description`,
      color: "subdued",
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("small", {
      css: truncationStyle
    }, option.description))));
  };
  const handleOpenPopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(true);
  }, [setIsPopoverOpen]);
  const handleClosePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, [setIsPopoverOpen]);

  // Focus on the console's input element when the popover closes
  (0, _react.useEffect)(() => {
    if (!state.isPopoverOpen && requestFocus) {
      // Use setTimeout to ensure focus happens after the popover closes
      setTimeout(() => {
        requestFocus();
      }, 0);
    }
  }, [state.isPopoverOpen, requestFocus]);
  const handleScriptSelection = (0, _react.useCallback)((newOptions, _event, changedOption) => {
    if (changedOption.checked === 'on') {
      onChange({
        value: changedOption.label,
        valueText: changedOption.label,
        store: {
          ...state,
          isPopoverOpen: false
        }
      });
    } else {
      onChange({
        value: '',
        valueText: '',
        store: {
          ...state,
          isPopoverOpen: false
        }
      });
    }
  }, [onChange, state]);

  // notifications comes from useKibana() and is of type NotificationsStart
  // which is compatible with our updated useCustomScriptsErrorToast function
  (0, _use_custom_scripts_error_toast.useCustomScriptsErrorToast)(scriptsError, notifications);
  if (isAwaitingRenderDelay || isLoadingScripts && !scriptsError) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: state.isPopoverOpen,
    offset: 10,
    panelStyle: {
      padding: 0,
      minWidth: 400
    },
    closePopover: handleClosePopover,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: TOOLTIP_TEXT,
      position: "top",
      display: "block"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      alignItems: "center",
      gutterSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      onClick: handleOpenPopover
    }, /*#__PURE__*/_react.default.createElement("div", {
      title: valueText
    }, valueText || INITIAL_DISPLAY_LABEL))))
  }, state.isPopoverOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    id: "options-combobox",
    searchable: true,
    options: scriptsOptions,
    onChange: handleScriptSelection,
    renderOption: renderOption,
    singleSelection: true,
    searchProps: {
      placeholder: valueText || INITIAL_DISPLAY_LABEL,
      autoFocus: true,
      onKeyDown: event => {
        // Only stop propagation for typing keys, not for navigation keys - otherwise input lose focus
        if (!['Enter', 'ArrowUp', 'ArrowDown', 'Escape'].includes(event.key)) {
          event.stopPropagation();
        }
      }
    },
    listProps: {
      rowHeight: 60,
      showIcons: true,
      textWrap: 'truncate'
    },
    errorMessage: scriptsError ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpoint.customScriptSelector.errorLoading",
      defaultMessage: "Error loading scripts"
    }) : undefined
  }, (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    css: {
      margin: 5
    }
  }, search), list)));
});
CustomScriptSelector.displayName = 'CustomScriptSelector';