"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInputHints = exports.UP_ARROW_ACCESS_HISTORY_HINT = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _use_with_input_text_entered = require("../../../hooks/state_selectors/use_with_input_text_entered");
var _parsed_command_input = require("../../../service/parsed_command_input");
var _use_console_state_dispatch = require("../../../hooks/state_selectors/use_console_state_dispatch");
var _use_with_input_show_popover = require("../../../hooks/state_selectors/use_with_input_show_popover");
var _use_with_input_command_entered = require("../../../hooks/state_selectors/use_with_input_command_entered");
var _use_with_command_list = require("../../../hooks/state_selectors/use_with_command_list");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UNKNOWN_COMMAND_HINT = commandName => _i18n.i18n.translate('xpack.securitySolution.useInputHints.unknownCommand', {
  defaultMessage: 'Unknown command {commandName}',
  values: {
    commandName
  }
});
const NO_ARGUMENTS_HINT = _i18n.i18n.translate('xpack.securitySolution.useInputHints.noArguments', {
  defaultMessage: 'Hit enter to execute'
});
const UP_ARROW_ACCESS_HISTORY_HINT = exports.UP_ARROW_ACCESS_HISTORY_HINT = _i18n.i18n.translate('xpack.securitySolution.useInputHints.viewInputHistory', {
  defaultMessage: 'Press the up arrow key to access previously entered commands'
});

/**
 * Auto-generates console footer "hints" while user is interacting with the input area
 */
const useInputHints = () => {
  const dispatch = (0, _use_console_state_dispatch.useConsoleStateDispatch)();
  const isInputPopoverOpen = Boolean((0, _use_with_input_show_popover.useWithInputShowPopover)());
  const commandEntered = (0, _use_with_input_command_entered.useWithInputCommandEntered)();
  const commandList = (0, _use_with_command_list.useWithCommandList)();
  const {
    leftOfCursorText
  } = (0, _use_with_input_text_entered.useWithInputTextEntered)();
  const commandEnteredDefinition = (0, _react.useMemo)(() => {
    if (commandEntered) {
      return commandList.find(commandDef => commandDef.name === commandEntered);
    }
  }, [commandEntered, commandList]);
  (0, _react.useEffect)(() => {
    // If we know the command name and the input popover is not opened, then show hints (if any)
    if (commandEntered && !isInputPopoverOpen) {
      // Is valid command name? ==> show usage
      if (commandEnteredDefinition && commandEnteredDefinition.helpHidden !== true) {
        var _commandEnteredDefini, _commandEnteredDefini2;
        const exampleInstruction = (_commandEnteredDefini = commandEnteredDefinition === null || commandEnteredDefinition === void 0 ? void 0 : commandEnteredDefinition.exampleInstruction) !== null && _commandEnteredDefini !== void 0 ? _commandEnteredDefini : '';
        const exampleUsage = (_commandEnteredDefini2 = commandEnteredDefinition === null || commandEnteredDefinition === void 0 ? void 0 : commandEnteredDefinition.exampleUsage) !== null && _commandEnteredDefini2 !== void 0 ? _commandEnteredDefini2 : '';
        let hint = exampleInstruction !== null && exampleInstruction !== void 0 ? exampleInstruction : '';
        if (exampleUsage) {
          if (exampleInstruction) {
            // leading space below is intentional
            hint += ` ${_i18n.i18n.translate('xpack.securitySolution.useInputHints.exampleInstructions', {
              defaultMessage: 'Ex: [ {exampleUsage} ]',
              values: {
                exampleUsage
              }
            })}`;
          } else {
            hint += exampleUsage;
          }
        }

        // If the command did not define any hint, then generate the command useage from the definition.
        // If the command did define `exampleInstruction` but not `exampleUsage`, then generate the
        // usage from the command definition and then append it.
        //
        // Generated usage is only created if the command has arguments.
        if (!hint || !exampleUsage) {
          const commandArguments = (0, _parsed_command_input.getArgumentsForCommand)(commandEnteredDefinition);
          if (commandArguments.length > 0) {
            hint += `${commandEnteredDefinition.name} ${commandArguments}`;
          } else {
            hint += NO_ARGUMENTS_HINT;
          }
        }
        dispatch({
          type: 'updateFooterContent',
          payload: {
            value: hint
          }
        });
        dispatch({
          type: 'setInputState',
          payload: {
            value: undefined
          }
        });
      } else {
        dispatch({
          type: 'updateFooterContent',
          payload: {
            value: UNKNOWN_COMMAND_HINT(commandEntered)
          }
        });
        dispatch({
          type: 'setInputState',
          payload: {
            value: 'error'
          }
        });
      }
    } else {
      dispatch({
        type: 'updateFooterContent',
        payload: {
          value: leftOfCursorText || isInputPopoverOpen ? '' : UP_ARROW_ACCESS_HISTORY_HINT
        }
      });
      dispatch({
        type: 'setInputState',
        payload: {
          value: undefined
        }
      });
    }
  }, [commandEntered, commandEnteredDefinition, dispatch, isInputPopoverOpen, leftOfCursorText]);
};
exports.useInputHints = useInputHints;