"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTrailingBreadcrumbs = void 0;
var _types = require("../../../app/types");
var _link_to = require("../../../common/components/link_to");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This module should only export this function.
 * All the `getTrailingBreadcrumbs` functions in Security are loaded into the main bundle.
 * We should be careful to not import unnecessary modules in this file to avoid increasing the main app bundle size.
 */
const getTrailingBreadcrumbs = (params, getSecuritySolutionUrl) => {
  let breadcrumb = [];
  if (params.detailName != null) {
    breadcrumb = [{
      text: params.detailName,
      href: getSecuritySolutionUrl({
        path: (0, _link_to.getKubernetesDetailsUrl)(params.detailName, ''),
        deepLinkId: _types.SecurityPageName.kubernetes
      })
    }];
  }
  return breadcrumb;
};
exports.getTrailingBreadcrumbs = getTrailingBreadcrumbs;