"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.links = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../../common/constants");
var _translations = require("../app/translations");
var _kubernetes_page = _interopRequireDefault(require("../common/images/kubernetes_page.png"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const links = exports.links = {
  id: _constants.SecurityPageName.kubernetes,
  title: _translations.KUBERNETES,
  landingImage: _kubernetes_page.default,
  description: _i18n.i18n.translate('xpack.securitySolution.appLinks.kubernetesDescription', {
    defaultMessage: 'Provides interactive visualizations of your Kubernetes workload and session data.'
  }),
  path: _constants.KUBERNETES_PATH,
  experimentalKey: 'kubernetesEnabled',
  globalSearchKeywords: ['Kubernetes']
};