"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isFlyoutLink = exports.getRightPanelParams = exports.getPreviewPanelParams = void 0;
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _network = require("../../../../common/search_strategy/security_solution/network");
var _table_field_name_cell = require("../../document_details/right/components/table_field_name_cell");
var _constants = require("../../../timelines/components/timeline/body/renderers/constants");
var _constants2 = require("../../entity_details/shared/constants");
var _host_right = require("../../entity_details/host_right");
var _host_entity_overview = require("../../document_details/right/components/host_entity_overview");
var _user_right = require("../../entity_details/user_right");
var _user_entity_overview = require("../../document_details/right/components/user_entity_overview");
var _network_details = require("../../network_details");
var _right = require("../../rule_details/right");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Helper function to check if the field has a flyout link
const isFlyoutLink = ({
  field,
  ruleId,
  scopeId
}) => {
  var _getEcsField;
  // don't show link for rule name if rule id is not provided or if isRulePreview is true
  if (field === _constants.SIGNAL_RULE_NAME_FIELD_NAME) {
    return !!ruleId && scopeId !== _securitysolutionDataTable.TableId.rulePreview;
  }
  return FLYOUT_FIELDS.includes(field) || ((_getEcsField = (0, _table_field_name_cell.getEcsField)(field)) === null || _getEcsField === void 0 ? void 0 : _getEcsField.type) === _constants.IP_FIELD_TYPE;
};
exports.isFlyoutLink = isFlyoutLink;
const FLYOUT_FIELDS = [_constants.HOST_NAME_FIELD_NAME, _constants.USER_NAME_FIELD_NAME, _constants.SIGNAL_RULE_NAME_FIELD_NAME];

// Helper get function to get flyout parameters based on field name and isFlyoutOpen
// If flyout is currently open, preview panel params are returned
// If flyout is not currently open, flyout rightpanel params are returned
const getRightPanelParams = ({
  value,
  field,
  scopeId,
  ruleId
}) => {
  var _getEcsField2;
  if (!isFlyoutLink({
    field,
    ruleId,
    scopeId
  })) {
    return null;
  }
  if (((_getEcsField2 = (0, _table_field_name_cell.getEcsField)(field)) === null || _getEcsField2 === void 0 ? void 0 : _getEcsField2.type) === _constants.IP_FIELD_TYPE) {
    return {
      id: _network_details.NetworkPanelKey,
      params: {
        ip: value,
        scopeId,
        flowTarget: field.includes(_network.FlowTargetSourceDest.destination) ? _network.FlowTargetSourceDest.destination : _network.FlowTargetSourceDest.source
      }
    };
  }
  switch (field) {
    case _constants.HOST_NAME_FIELD_NAME:
      return {
        id: _constants2.HostPanelKey,
        params: {
          hostName: value,
          scopeId
        }
      };
    case _constants.USER_NAME_FIELD_NAME:
      return {
        id: _constants2.UserPanelKey,
        params: {
          userName: value,
          scopeId
        }
      };
    case _constants.SIGNAL_RULE_NAME_FIELD_NAME:
      return {
        id: _right.RulePanelKey,
        params: {
          ruleId
        }
      };
    default:
      return null;
  }
};
exports.getRightPanelParams = getRightPanelParams;
const getPreviewPanelParams = ({
  value,
  field,
  scopeId,
  ruleId
}) => {
  var _getEcsField3;
  if (!isFlyoutLink({
    field,
    ruleId,
    scopeId
  })) {
    return null;
  }
  if (((_getEcsField3 = (0, _table_field_name_cell.getEcsField)(field)) === null || _getEcsField3 === void 0 ? void 0 : _getEcsField3.type) === _constants.IP_FIELD_TYPE) {
    return {
      id: _network_details.NetworkPreviewPanelKey,
      params: {
        ip: value,
        scopeId,
        flowTarget: field.includes(_network.FlowTargetSourceDest.destination) ? _network.FlowTargetSourceDest.destination : _network.FlowTargetSourceDest.source,
        banner: _network_details.NETWORK_PREVIEW_BANNER
      }
    };
  }
  switch (field) {
    case _constants.HOST_NAME_FIELD_NAME:
      return {
        id: _host_right.HostPreviewPanelKey,
        params: {
          hostName: value,
          scopeId,
          banner: _host_entity_overview.HOST_PREVIEW_BANNER
        }
      };
    case _constants.USER_NAME_FIELD_NAME:
      return {
        id: _user_right.UserPreviewPanelKey,
        params: {
          userName: value,
          scopeId,
          banner: _user_entity_overview.USER_PREVIEW_BANNER
        }
      };
    case _constants.SIGNAL_RULE_NAME_FIELD_NAME:
      return {
        id: _right.RulePreviewPanelKey,
        params: {
          ruleId,
          banner: _right.RULE_PREVIEW_BANNER,
          isPreviewMode: true
        }
      };
    default:
      return null;
  }
};
exports.getPreviewPanelParams = getPreviewPanelParams;