"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HighlightedFieldsCell = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _get_agent_type_for_agent_id_field = require("../../../../common/lib/endpoint/utils/get_agent_type_for_agent_id_field");
var _agent_status = require("../../../../common/components/endpoint/agents/agent_status");
var _constants = require("../../../../timelines/components/timeline/body/renderers/constants");
var _test_ids = require("./test_ids");
var _link_utils = require("../../../shared/utils/link_utils");
var _preview_link = require("../../../shared/components/preview_link");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Renders a component in the highlighted fields table cell based on the field name
 */
const HighlightedFieldsCell = ({
  values,
  field,
  originalField = '',
  scopeId = '',
  showPreview = false
}) => {
  const agentType = (0, _react.useMemo)(() => {
    return (0, _get_agent_type_for_agent_id_field.getAgentTypeForAgentIdField)(originalField);
  }, [originalField]);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    css: (0, _react2.css)`
        div {
          margin-bottom: ${euiTheme.size.xs};
        }

        div:last-child {
          margin-bottom: 0;
        }
      `
  }, values != null && values.map((value, i) => {
    return /*#__PURE__*/_react.default.createElement("div", {
      key: `${i}-${value}`,
      "data-test-subj": `${value}-${_test_ids.HIGHLIGHTED_FIELDS_CELL_TEST_ID}`
    }, showPreview && (0, _link_utils.isFlyoutLink)({
      field,
      scopeId
    }) ? /*#__PURE__*/_react.default.createElement(_preview_link.PreviewLink, {
      field: field,
      value: value,
      scopeId: scopeId,
      "data-test-subj": _test_ids.HIGHLIGHTED_FIELDS_LINKED_CELL_TEST_ID
    }) : field === _constants.AGENT_STATUS_FIELD_NAME ? /*#__PURE__*/_react.default.createElement(_agent_status.AgentStatus, {
      agentId: String(value !== null && value !== void 0 ? value : ''),
      agentType: agentType,
      "data-test-subj": _test_ids.HIGHLIGHTED_FIELDS_AGENT_STATUS_CELL_TEST_ID
    }) : /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": _test_ids.HIGHLIGHTED_FIELDS_BASIC_CELL_TEST_ID
    }, value));
  }));
};
exports.HighlightedFieldsCell = HighlightedFieldsCell;