"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InsightsTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _kibana = require("../../../../common/lib/kibana");
var _test_ids = require("./test_ids");
var _context = require("../../shared/context");
var _panel_keys = require("../../shared/constants/panel_keys");
var _ = require("..");
var _entities_details = require("../components/entities_details");
var _threat_intelligence_details = require("../components/threat_intelligence_details");
var _prevalence_details = require("../components/prevalence_details");
var _correlations_details = require("../components/correlations_details");
var _utils = require("../../shared/utils");
var _event_kinds = require("../../shared/constants/event_kinds");
var _telemetry = require("../../../../common/lib/telemetry");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ENTITIES_TAB_ID = 'entity';
const insightsButtons = [{
  id: ENTITIES_TAB_ID,
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.entitiesButtonLabel",
    defaultMessage: "Entities"
  }),
  'data-test-subj': _test_ids.INSIGHTS_TAB_ENTITIES_BUTTON_TEST_ID
}, {
  id: _threat_intelligence_details.THREAT_INTELLIGENCE_TAB_ID,
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.threatIntelligenceButtonLabel",
    defaultMessage: "Threat intelligence"
  }),
  'data-test-subj': _test_ids.INSIGHTS_TAB_THREAT_INTELLIGENCE_BUTTON_TEST_ID
}, {
  id: _prevalence_details.PREVALENCE_TAB_ID,
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.prevalenceButtonLabel",
    defaultMessage: "Prevalence"
  }),
  'data-test-subj': _test_ids.INSIGHTS_TAB_PREVALENCE_BUTTON_TEST_ID
}, {
  id: _correlations_details.CORRELATIONS_TAB_ID,
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.correlationsButtonLabel",
    defaultMessage: "Correlations"
  }),
  'data-test-subj': _test_ids.INSIGHTS_TAB_CORRELATIONS_BUTTON_TEST_ID
}];

/**
 * Insights view displayed in the document details expandable flyout left section
 */
const InsightsTab = exports.InsightsTab = /*#__PURE__*/(0, _react.memo)(() => {
  var _panels$left$path$sub, _panels$left, _panels$left$path;
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const {
    eventId,
    indexName,
    scopeId,
    getFieldsData
  } = (0, _context.useDocumentDetailsContext)();
  const isEventKindSignal = (0, _utils.getField)(getFieldsData('event.kind')) === _event_kinds.EventKind.signal;
  const {
    openLeftPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const panels = (0, _expandableFlyout.useExpandableFlyoutState)();
  const activeInsightsId = (_panels$left$path$sub = (_panels$left = panels.left) === null || _panels$left === void 0 ? void 0 : (_panels$left$path = _panels$left.path) === null || _panels$left$path === void 0 ? void 0 : _panels$left$path.subTab) !== null && _panels$left$path$sub !== void 0 ? _panels$left$path$sub : ENTITIES_TAB_ID;

  // insight tabs based on whether document is alert or non-alert
  // alert: entities, threat intelligence, prevalence, correlations
  // non-alert: entities, prevalence, correlations
  const buttonGroup = (0, _react.useMemo)(() => isEventKindSignal ? insightsButtons : insightsButtons.filter(tab => tab.id !== _threat_intelligence_details.THREAT_INTELLIGENCE_TAB_ID), [isEventKindSignal]);
  const onChangeCompressed = (0, _react.useCallback)(optionId => {
    openLeftPanel({
      id: _panel_keys.DocumentDetailsLeftPanelKey,
      path: {
        tab: _.LeftPanelInsightsTab,
        subTab: optionId
      },
      params: {
        id: eventId,
        indexName,
        scopeId
      }
    });
    telemetry.reportEvent(_telemetry.DocumentEventTypes.DetailsFlyoutTabClicked, {
      location: scopeId,
      panel: 'left',
      tabId: optionId
    });
  }, [eventId, indexName, scopeId, openLeftPanel, telemetry]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    color: "primary",
    legend: _i18n.i18n.translate('xpack.securitySolution.flyout.left.insights.buttonGroupLegendLabel', {
      defaultMessage: 'Insights options'
    }),
    options: buttonGroup,
    idSelected: activeInsightsId,
    onChange: onChangeCompressed,
    buttonSize: "compressed",
    isFullWidth: true,
    "data-test-subj": _test_ids.INSIGHTS_TAB_BUTTON_GROUP_TEST_ID,
    style: !isEventKindSignal ? {
      maxWidth: 450
    } : undefined
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), activeInsightsId === ENTITIES_TAB_ID && /*#__PURE__*/_react.default.createElement(_entities_details.EntitiesDetails, null), activeInsightsId === _threat_intelligence_details.THREAT_INTELLIGENCE_TAB_ID && /*#__PURE__*/_react.default.createElement(_threat_intelligence_details.ThreatIntelligenceDetails, null), activeInsightsId === _prevalence_details.PREVALENCE_TAB_ID && /*#__PURE__*/_react.default.createElement(_prevalence_details.PrevalenceDetails, null), activeInsightsId === _correlations_details.CORRELATIONS_TAB_ID && /*#__PURE__*/_react.default.createElement(_correlations_details.CorrelationsDetails, null));
});
InsightsTab.displayName = 'InsightsTab';