"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResponseDetails = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _test_ids = require("./test_ids");
var _context = require("../../shared/context");
var _use_response_actions_view = require("../hooks/use_response_actions_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExtendedFlyoutWrapper = _styledComponents.default.div`
 figure {
  background-color: white
`;

/**
 * Automated response actions results, displayed in the document details expandable flyout left section under the Insights tab, Response tab
 */
const ResponseDetails = () => {
  const {
    searchHit,
    dataAsNestedObject,
    isRulePreview
  } = (0, _context.useDocumentDetailsContext)();
  const responseActionsView = (0, _use_response_actions_view.useResponseActionsView)({
    rawEventData: searchHit,
    ecsData: dataAsNestedObject
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _test_ids.RESPONSE_DETAILS_TEST_ID
  }, isRulePreview ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.response.previewMessage",
    defaultMessage: "Response is not available in alert preview."
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.response.responseTitle",
    defaultMessage: "Responses"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(ExtendedFlyoutWrapper, null, responseActionsView === null || responseActionsView === void 0 ? void 0 : responseActionsView.content)));
};
exports.ResponseDetails = ResponseDetails;
ResponseDetails.displayName = 'ResponseDetails';