"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VIEW_CONVERSATIONS_BUTTON_TEST_ID = exports.LOADING_SKELETON_TEST_ID = exports.Conversations = exports.CONVERSATION_COUNT_TEST_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOADING_SKELETON_TEST_ID = exports.LOADING_SKELETON_TEST_ID = 'ai-for-soc-alert-flyout-conversation-loading-skeleton';
const CONVERSATION_COUNT_TEST_ID = exports.CONVERSATION_COUNT_TEST_ID = 'ai-for-soc-alert-flyout-conversation-count';
const VIEW_CONVERSATIONS_BUTTON_TEST_ID = exports.VIEW_CONVERSATIONS_BUTTON_TEST_ID = 'ai-for-soc-alert-flyout-view-conversations';
const YOUR_CONVERSATIONS = _i18n.i18n.translate('xpack.securitySolution.aiAssistant.yourConversations', {
  defaultMessage: 'Your conversations'
});
const VIEW = _i18n.i18n.translate('xpack.securitySolution.aiAssistant.view', {
  defaultMessage: 'View'
});
/**
 * Component rendered in the AI assistant section of the AI for SOC alert flyout.
 * It fetches user conversations related to the alertId passed as input.
 * If no id is provided, we display a list of default conversations.
 */
const Conversations = exports.Conversations = /*#__PURE__*/(0, _react.memo)(({
  alertId
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    http,
    assistantAvailability: {
      isAssistantEnabled
    },
    showAssistantOverlay
  } = (0, _elasticAssistant.useAssistantContext)();
  const {
    data: conversations,
    isFetched: conversationsLoaded
  } = (0, _elasticAssistant.useFetchCurrentUserConversations)({
    http,
    isAssistantEnabled,
    filter: `messages:{ content : "${alertId}" }`
  });
  const conversationCount = (0, _react.useMemo)(() => Object.keys(conversations).length, [conversations]);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const togglePopover = (0, _react.useCallback)(() => setIsPopoverOpen(!isPopoverOpen), [isPopoverOpen]);
  const closePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), []);
  const onSelectConversation = (0, _react.useCallback)(conversationId => {
    closePopover();
    showAssistantOverlay({
      showOverlay: true,
      selectedConversation: {
        id: conversationId
      }
    });
  }, [closePopover, showAssistantOverlay]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    color: "subdued",
    hasBorder: true
  }, conversationsLoaded ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, YOUR_CONVERSATIONS))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    css: (0, _react2.css)`
                      color: ${euiTheme.colors.textPrimary};
                    `,
    "data-test-subj": CONVERSATION_COUNT_TEST_ID
  }, conversationCount)))), conversationCount > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": VIEW_CONVERSATIONS_BUTTON_TEST_ID,
      iconSide: "right",
      iconType: "arrowDown",
      onClick: togglePopover
    }, VIEW),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    anchorPosition: "downRight"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, null, Object.values(conversations).map(conversation => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: conversation.id,
    onClick: () => onSelectConversation(conversation.id)
  }, conversation.title)))))) : /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    "data-test-subj": LOADING_SKELETON_TEST_ID,
    lines: 1,
    size: "xs"
  })));
});
Conversations.displayName = 'Conversations';