"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.REGENERATE_INSIGHTS_BUTTON_TEST_ID = exports.GENERATE_INSIGHTS_BUTTON_TEST_ID = exports.AlertSummary = exports.ALERT_SUMMARY_TEST_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _aiAssistantIcon = require("@kbn/ai-assistant-icon");
var _i18n = require("@kbn/i18n");
var _connector_missing_callout = require("./connector_missing_callout");
var _use_alert_summary = require("../hooks/use_alert_summary");
var _message_text = require("./message_text");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERT_SUMMARY_TEST_ID = exports.ALERT_SUMMARY_TEST_ID = 'ai-for-soc-alert-flyout-alert-summary';
const GENERATE_INSIGHTS_BUTTON_TEST_ID = exports.GENERATE_INSIGHTS_BUTTON_TEST_ID = 'ai-for-soc-alert-flyout-generate-insights-button';
const REGENERATE_INSIGHTS_BUTTON_TEST_ID = exports.REGENERATE_INSIGHTS_BUTTON_TEST_ID = 'ai-for-soc-alert-flyout-regenerate-insights-button';
const RECOMMENDED_ACTIONS = _i18n.i18n.translate('xpack.securitySolution.alertSummary.recommendedActions', {
  defaultMessage: 'Recommended actions'
});
const GENERATING = _i18n.i18n.translate('xpack.securitySolution.alertSummary.generating', {
  defaultMessage: 'Generating AI description and recommended actions.'
});
const GENERATE = _i18n.i18n.translate('xpack.securitySolution.alertSummary.generate', {
  defaultMessage: 'Generate insights'
});
const REGENERATE = _i18n.i18n.translate('xpack.securitySolution.alertSummary.regenerate', {
  defaultMessage: 'Regenerate insights'
});
/**
 * Component generating the AI summary for the visualized alert and showing in the alert summary section of the AI for SOC flyout.
 */
const AlertSummary = exports.AlertSummary = /*#__PURE__*/(0, _react.memo)(({
  alertId,
  canSeeAdvancedSettings,
  defaultConnectorId,
  promptContext,
  setHasAlertSummary,
  showAnonymizedValues
}) => {
  const {
    alertSummary,
    recommendedActions,
    hasAlertSummary,
    fetchAISummary,
    isConnectorMissing,
    isLoading,
    messageAndReplacements
  } = (0, _use_alert_summary.useAlertSummary)({
    alertId,
    defaultConnectorId,
    promptContext,
    showAnonymizedValues
  });
  (0, _react.useEffect)(() => {
    setHasAlertSummary(hasAlertSummary);
  }, [hasAlertSummary, setHasAlertSummary]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hasAlertSummary ? isLoading ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    css: (0, _react2.css)`
                  font-style: italic;
                `,
    size: "s",
    "data-test-subj": ALERT_SUMMARY_TEST_ID
  }, GENERATING), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 3,
    size: "s"
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isConnectorMissing && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_connector_missing_callout.ConnectorMissingCallout, {
    canSeeAdvancedSettings: canSeeAdvancedSettings
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_message_text.MessageText, {
    content: alertSummary
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), recommendedActions && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, RECOMMENDED_ACTIONS), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_message_text.MessageText, {
    content: recommendedActions
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: fetchAISummary,
    color: "primary",
    size: "m",
    "data-test-subj": REGENERATE_INSIGHTS_BUTTON_TEST_ID,
    isLoading: messageAndReplacements == null
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    responsive: false,
    wrap: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_aiAssistantIcon.AssistantIcon, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, REGENERATE)))))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: fetchAISummary,
    color: "primary",
    size: "m",
    "data-test-subj": GENERATE_INSIGHTS_BUTTON_TEST_ID,
    isLoading: messageAndReplacements == null
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_aiAssistantIcon.AssistantIcon, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, GENERATE))))));
});
AlertSummary.displayName = 'AlertSummary';