"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setHostsQueriesActivePageToZero = exports.setHostPageQueriesActivePageToZero = exports.setHostDetailsQueriesActivePageToZero = exports.generateSeverityFilter = void 0;
var _search_strategy = require("../../../../common/search_strategy");
var _constants = require("../../../common/store/constants");
var _model = require("./model");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const setHostPageQueriesActivePageToZero = state => ({
  ...state.page.queries,
  [_model.HostsTableType.authentications]: {
    ...state.page.queries[_model.HostsTableType.authentications],
    activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE
  },
  [_model.HostsTableType.hosts]: {
    ...state.page.queries[_model.HostsTableType.hosts],
    activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE
  },
  [_model.HostsTableType.events]: {
    ...state.page.queries[_model.HostsTableType.events],
    activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE
  },
  [_model.HostsTableType.uncommonProcesses]: {
    ...state.page.queries[_model.HostsTableType.uncommonProcesses],
    activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE
  }
});
exports.setHostPageQueriesActivePageToZero = setHostPageQueriesActivePageToZero;
const setHostDetailsQueriesActivePageToZero = state => ({
  ...state.details.queries,
  [_model.HostsTableType.authentications]: {
    ...state.details.queries[_model.HostsTableType.authentications],
    activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE
  },
  [_model.HostsTableType.hosts]: {
    ...state.details.queries[_model.HostsTableType.hosts],
    activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE
  },
  [_model.HostsTableType.events]: {
    ...state.details.queries[_model.HostsTableType.events],
    activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE
  },
  [_model.HostsTableType.uncommonProcesses]: {
    ...state.details.queries[_model.HostsTableType.uncommonProcesses],
    activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE
  }
});
exports.setHostDetailsQueriesActivePageToZero = setHostDetailsQueriesActivePageToZero;
const setHostsQueriesActivePageToZero = (state, type) => {
  if (type === _model.HostsType.page) {
    return setHostPageQueriesActivePageToZero(state);
  } else if (type === _model.HostsType.details) {
    return setHostDetailsQueriesActivePageToZero(state);
  }
  throw new Error(`HostsType ${type} is unknown`);
};
exports.setHostsQueriesActivePageToZero = setHostsQueriesActivePageToZero;
const generateSeverityFilter = (severitySelection, entity) => severitySelection.length > 0 ? [{
  query: {
    bool: {
      should: severitySelection.map(query => ({
        match_phrase: {
          [_search_strategy.EntityTypeToLevelField[entity]]: {
            query
          }
        }
      }))
    }
  },
  meta: {
    alias: null,
    disabled: false,
    negate: false
  }
}] : [];
exports.generateSeverityFilter = generateSeverityFilter;