"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KpiBaseComponent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _stat_items = require("../stat_items");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KpiBaseComponent = exports.KpiBaseComponent = /*#__PURE__*/_react.default.memo(({
  statItems,
  ...props
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  wrap: true
}, statItems.map(statItem => /*#__PURE__*/_react.default.createElement(_stat_items.StatItemsComponent, (0, _extends2.default)({}, props, {
  key: `kpi-base-${statItem.key}`,
  statItems: statItem
})))));
KpiBaseComponent.displayName = 'KpiBaseComponent';