"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ListExceptionItems = void 0;
var _react = _interopRequireWildcard(require("react"));
var _securitysolutionExceptionListComponents = require("@kbn/securitysolution-exception-list-components");
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _formatted_date = require("../../../common/components/formatted_date");
var _ui = require("../../utils/ui.helpers");
var _link_to_rule_details = require("../link_to_rule_details");
var _exceptions_utility = require("../exceptions_utility");
var i18n = _interopRequireWildcard(require("../../translations/list_exception_items"));
var _use_endpoint_exceptions_capability = require("../../hooks/use_endpoint_exceptions_capability");
var _show_value_list_modal = require("../../../value_list/components/show_value_list_modal");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ListExceptionItemsComponent = ({
  isReadOnly,
  exceptions,
  listType,
  lastUpdated,
  pagination,
  emptyViewerTitle,
  emptyViewerBody,
  emptyViewerButtonText,
  viewerStatus,
  ruleReferences,
  hideUtility = false,
  onDeleteException,
  onEditExceptionItem,
  onPaginationChange,
  onCreateExceptionListItem
}) => {
  const canWriteEndpointExceptions = (0, _use_endpoint_exceptions_capability.useEndpointExceptionsCapability)('crudEndpointExceptions');
  const editButtonText = (0, _react.useMemo)(() => {
    return listType === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT ? i18n.EXCEPTION_ITEM_CARD_EDIT_ENDPOINT_LABEL : i18n.EXCEPTION_ITEM_CARD_EDIT_LABEL;
  }, [listType]);
  const deleteButtonText = (0, _react.useMemo)(() => {
    return listType === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT ? i18n.EXCEPTION_ITEM_CARD_DELETE_ENDPOINT_LABEL : i18n.EXCEPTION_ITEM_CARD_DELETE_LABEL;
  }, [listType]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_securitysolutionExceptionListComponents.ExceptionItems, {
    viewerStatus: viewerStatus,
    listType: listType,
    ruleReferences: ruleReferences,
    isReadOnly: isReadOnly || !canWriteEndpointExceptions,
    exceptions: exceptions,
    emptyViewerTitle: emptyViewerTitle,
    emptyViewerBody: emptyViewerBody,
    emptyViewerButtonText: emptyViewerButtonText,
    pagination: pagination,
    lastUpdated: lastUpdated,
    editActionLabel: editButtonText,
    deleteActionLabel: deleteButtonText,
    onPaginationChange: onPaginationChange,
    onEditExceptionItem: onEditExceptionItem,
    onDeleteException: onDeleteException,
    getFormattedComments: _ui.getFormattedComments,
    securityLinkAnchorComponent: _link_to_rule_details.LinkToRuleDetails,
    formattedDateComponent: _formatted_date.FormattedDate,
    onCreateExceptionListItem: onCreateExceptionListItem,
    exceptionsUtilityComponent: () => hideUtility ? null : /*#__PURE__*/_react.default.createElement(_exceptions_utility.ExceptionsUtility, {
      exceptionsTitle: i18n.EXCEPTION_UTILITY_TITLE,
      pagination: pagination,
      lastUpdated: lastUpdated
    }),
    showValueListModal: _show_value_list_modal.ShowValueListModal
  }));
};
ListExceptionItemsComponent.displayName = 'ListExceptionItemsComponent';
const ListExceptionItems = exports.ListExceptionItems = /*#__PURE__*/_react.default.memo(ListExceptionItemsComponent);
ListExceptionItems.displayName = 'ListExceptionItems';