"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskScoreLevel = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _react2 = require("@emotion/react");
var _utils = require("../../../common/utils");
var _hover_popover = require("../../../../common/components/hover_popover");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RiskBadge = (0, _styled.default)('div', {
  shouldForwardProp: prop => !['severity', 'hideBackgroundColor'].includes(prop)
})`
  ${({
  theme: {
    euiTheme
  },
  color,
  severity,
  hideBackgroundColor
}) => (0, _react2.css)`
    width: fit-content;
    padding-right: ${euiTheme.size.s};
    padding-left: ${euiTheme.size.xs};

    ${(severity === 'Critical' || severity === 'High') && !hideBackgroundColor && (0, _react2.css)`
      background-color: ${color};
      border-radius: 999px; // pill shaped
    `};
  `}
`;
const TooltipContainer = _styled.default.div`
  padding: ${({
  theme: {
    euiTheme
  }
}) => euiTheme.size.s};
`;
const RiskScoreLevel = exports.RiskScoreLevel = /*#__PURE__*/_react.default.memo(({
  severity,
  hideBackgroundColor = false,
  toolTipContent,
  'data-test-subj': dataTestSubj
}) => {
  if (toolTipContent != null) {
    return /*#__PURE__*/_react.default.createElement(_hover_popover.HoverPopover, {
      hoverContent: /*#__PURE__*/_react.default.createElement(TooltipContainer, null, toolTipContent)
    }, /*#__PURE__*/_react.default.createElement(RiskScoreBadge, {
      severity: severity,
      hideBackgroundColor: hideBackgroundColor,
      "data-test-subj": dataTestSubj
    }));
  }
  return /*#__PURE__*/_react.default.createElement(RiskScoreBadge, {
    severity: severity,
    hideBackgroundColor: hideBackgroundColor,
    "data-test-subj": dataTestSubj
  });
});
RiskScoreLevel.displayName = 'RiskScoreLevel';
const RiskScoreBadge = /*#__PURE__*/_react.default.memo(({
  severity,
  hideBackgroundColor = false,
  'data-test-subj': dataTestSubj
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  // TODO: use riskSeverity hook when palette agreed.
  // https://github.com/elastic/security-team/issues/11516 hook - https://github.com/elastic/kibana/pull/206276
  return /*#__PURE__*/_react.default.createElement(RiskBadge, {
    color: euiTheme.colors.backgroundBaseDanger,
    severity: severity,
    hideBackgroundColor: hideBackgroundColor,
    "data-test-subj": dataTestSubj !== null && dataTestSubj !== void 0 ? dataTestSubj : 'risk-score'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "default"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    className: "eui-alignMiddle",
    color: _utils.RISK_SEVERITY_COLOUR[severity]
  }, severity)));
});
RiskScoreBadge.displayName = 'RiskScoreBadge';