"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sourceFieldToText = exports.getEntityType = exports.EntityIconByType = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _fp = require("lodash/fp");
var _utils = require("../../../../common/entity_analytics/utils");
var _types = require("../../../../common/entity_analytics/types");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEntityType = record => {
  const allEntityTypes = (0, _utils.getAllEntityTypes)();
  const entityType = allEntityTypes.find(type => {
    return (0, _fp.get)(type, record) !== undefined;
  });
  if (!entityType) {
    throw new Error(`Unexpected entity: ${JSON.stringify(record)}`);
  }
  return entityType;
};
exports.getEntityType = getEntityType;
const EntityIconByType = exports.EntityIconByType = {
  [_types.EntityType.user]: 'user',
  [_types.EntityType.host]: 'storage',
  [_types.EntityType.service]: 'node'
};
const sourceFieldToText = source => {
  if (source.match(`^${_constants.RISK_SCORE_INDEX_PATTERN}`)) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.entityStore.helpers.sourceField.riskDescription",
      defaultMessage: "Risk"
    });
  }
  if (source.match(`^${_constants.ASSET_CRITICALITY_INDEX_PATTERN}`)) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.entityStore.helpers.sourceField.criticalityDescription",
      defaultMessage: "Asset Criticality"
    });
  }
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.entityStore.helpers.sourceField.eventDescription",
    defaultMessage: "Events"
  });
};
exports.sourceFieldToText = sourceFieldToText;