"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useColumns = exports.HEALTH_COLOR = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _entity_analytics = require("../../../../../../../common/api/entity_analytics");
var _kibana = require("../../../../../../common/lib/kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HEALTH_COLOR = exports.HEALTH_COLOR = {
  green: 'success',
  unknown: 'subdued',
  yellow: 'warning',
  red: 'danger'
};
const RESOURCE_TO_TEXT = {
  ingest_pipeline: 'Ingest Pipeline',
  enrich_policy: 'Enrich Policy',
  index: 'Index',
  component_template: 'Component Template',
  task: 'Task',
  transform: 'Transform',
  entity_definition: 'Entity Definition',
  entity_engine: 'Engine',
  index_template: 'Index Template'
};
const useColumns = (onToggleExpandedItem, expandedItems) => {
  const {
    getUrlForApp
  } = (0, _kibana.useKibana)().services.application;
  return (0, _react.useMemo)(() => [{
    field: 'resource',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.entityStore.enginesStatus.resourceColumnTitle",
      defaultMessage: "Resource"
    }),
    width: '20%',
    render: resource => RESOURCE_TO_TEXT[resource]
  }, {
    field: 'id',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.entityStore.enginesStatus.idColumnTitle",
      defaultMessage: "Identifier"
    }),
    render: (id, {
      resource,
      installed
    }) => {
      const path = getResourcePath(id, resource);
      if (!installed || !path) {
        return id;
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: getUrlForApp('management', {
          path
        })
      }, id);
    }
  }, {
    field: 'installed',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.entityStore.enginesStatus.installedColumnTitle",
      defaultMessage: "Installed"
    }),
    width: '10%',
    align: 'center',
    render: value => value ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      "data-test-subj": "installation-status",
      type: "check",
      color: "success",
      size: "l"
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      "data-test-subj": "installation-status",
      type: "cross",
      color: "danger",
      size: "l"
    })
  }, {
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.entityStore.enginesStatus.healthColumnTitle",
      defaultMessage: "Health"
    }),
    width: '10%',
    align: 'center',
    render: ({
      installed,
      resource,
      health
    }) => {
      if (!installed) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
        color: HEALTH_COLOR[health !== null && health !== void 0 ? health : 'green']
      });
    }
  }, {
    isExpander: true,
    align: 'right',
    width: '40px',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.entityStore.enginesStatus.expandRow",
      defaultMessage: "Expand row"
    }))),
    mobileOptions: {
      header: false
    },
    render: component => {
      const isItemExpanded = expandedItems.includes(component);
      return component.errors && component.errors.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        onClick: () => onToggleExpandedItem(component),
        "aria-label": isItemExpanded ? 'Collapse' : 'Expand',
        iconType: isItemExpanded ? 'arrowDown' : 'arrowRight'
      }) : null;
    }
  }], [expandedItems, getUrlForApp, onToggleExpandedItem]);
};
exports.useColumns = useColumns;
const getResourcePath = (id, resource) => {
  if (resource === _entity_analytics.EngineComponentResourceEnum.ingest_pipeline) {
    return `ingest/ingest_pipelines?pipeline=${id}`;
  }
  if (resource === _entity_analytics.EngineComponentResourceEnum.index_template) {
    return `data/index_management/templates/${id}`;
  }
  if (resource === _entity_analytics.EngineComponentResourceEnum.index) {
    return `data/index_management/indices/index_details?indexName=${id}`;
  }
  if (resource === _entity_analytics.EngineComponentResourceEnum.component_template) {
    return `data/index_management/component_templates/${id}`;
  }
  if (resource === _entity_analytics.EngineComponentResourceEnum.enrich_policy) {
    return `data/index_management/enrich_policies?policy=${id}`;
  }
  if (resource === _entity_analytics.EngineComponentResourceEnum.transform) {
    return `data/transform?_a=(transform:(queryText:'${id}'))`;
  }
  return null;
};