"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionColumn = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _use_risk_input_actions_panels = require("../hooks/use_risk_input_actions_panels");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ActionColumn = ({
  input
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const closePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), []);
  const togglePopover = (0, _react.useCallback)(() => setIsPopoverOpen(isOpen => !isOpen), []);
  const panels = (0, _use_risk_input_actions_panels.useRiskInputActionsPanels)([input], closePopover);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": "risk-inputs-actions",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      onClick: togglePopover,
      iconType: "boxesHorizontal",
      "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.entityDetails.riskInputs.actions.ariaLabel', {
        defaultMessage: 'Actions'
      }),
      color: "text"
    }),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels
  }));
};
exports.ActionColumn = ActionColumn;