"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CRITICALITY_LEVEL_COLOR = exports.AssetCriticalityBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// below will be updated with new severity color palette & shared security wide severity colors hook creation
const CRITICALITY_LEVEL_COLOR = exports.CRITICALITY_LEVEL_COLOR = {
  extreme_impact: '#E7664C',
  high_impact: '#DA8B45',
  medium_impact: 'D6BF57',
  low_impact: '#54B399',
  unassigned: _uiTheme.euiLightVars.euiColorMediumShade
};
const AssetCriticalityBadge = ({
  criticalityLevel = 'unassigned',
  style,
  dataTestSubj = 'asset-criticality-badge',
  className
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    "data-test-subj": dataTestSubj,
    color: CRITICALITY_LEVEL_COLOR[criticalityLevel],
    style: style,
    className: className
  }, _translations.CRITICALITY_LEVEL_TITLE[criticalityLevel]);
};
exports.AssetCriticalityBadge = AssetCriticalityBadge;