"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchIntegrations = void 0;
var _react = require("react");
var _public = require("@kbn/fleet-plugin/public");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Fetches all integrations, then returns the installed and non-installed ones filtered with a list of
 * hard coded AI for SOC integrations:
 * - splunk
 * - google_secops
 * - microsoft_sentinel
 * - sentinel_one
 * - crowdstrike
 */
const useFetchIntegrations = () => {
  // TODO this might need to be revisited once the integration make it out of prerelease
  //  The issue will be that users will see prerelease versions and not the GA ones
  const {
    data: allPackages,
    isLoading
  } = (0, _public.useGetPackagesQuery)({
    prerelease: true
  });
  const aiForSOCPackages = (0, _react.useMemo)(() => ((allPackages === null || allPackages === void 0 ? void 0 : allPackages.items) || []).filter(pkg => _constants.AI_FOR_SOC_INTEGRATIONS.includes(pkg.name)), [allPackages]);
  const availablePackages = (0, _react.useMemo)(() => aiForSOCPackages.filter(pkg => pkg.status === _public.installationStatuses.NotInstalled), [aiForSOCPackages]);
  const installedPackages = (0, _react.useMemo)(() => aiForSOCPackages.filter(pkg => pkg.status === _public.installationStatuses.Installed || pkg.status === _public.installationStatuses.InstallFailed), [aiForSOCPackages]);
  return (0, _react.useMemo)(() => ({
    availablePackages,
    installedPackages,
    isLoading
  }), [availablePackages, installedPackages, isLoading]);
};
exports.useFetchIntegrations = useFetchIntegrations;