"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useListsPrivileges = void 0;
var _react = require("react");
var _user_privileges = require("../../../../common/components/user_privileges");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const canManageIndex = indexPrivileges => {
  const [indexName] = Object.keys(indexPrivileges);
  const privileges = indexPrivileges[indexName];
  if (privileges == null) {
    return false;
  }
  return privileges.manage;
};
const canReadIndex = indexPrivileges => {
  const [indexName] = Object.keys(indexPrivileges);
  const privileges = indexPrivileges[indexName];
  if (privileges == null) {
    return false;
  }
  return privileges.read;
};
const canWriteIndex = indexPrivileges => {
  const [indexName] = Object.keys(indexPrivileges);
  const privileges = indexPrivileges[indexName];
  if (privileges == null) {
    return false;
  }
  return privileges.create || privileges.create_doc || privileges.index || privileges.write;
};
const useListsPrivileges = () => {
  const [state, setState] = (0, _react.useState)({
    isAuthenticated: null,
    canManageIndex: null,
    canReadIndex: null,
    canWriteIndex: null
  });
  const {
    listPrivileges
  } = (0, _user_privileges.useUserPrivileges)();

  // handleReadResult
  (0, _react.useEffect)(() => {
    if (listPrivileges.result != null) {
      const {
        is_authenticated: isAuthenticated,
        lists: {
          index: listsPrivileges
        },
        listItems: {
          index: listItemsPrivileges
        }
      } = listPrivileges.result;
      setState({
        isAuthenticated,
        canReadIndex: canReadIndex(listsPrivileges) && canReadIndex(listItemsPrivileges),
        canManageIndex: canManageIndex(listsPrivileges) && canManageIndex(listItemsPrivileges),
        canWriteIndex: canWriteIndex(listsPrivileges) && canWriteIndex(listItemsPrivileges)
      });
    }
  }, [listPrivileges.result]);

  // handleReadError
  (0, _react.useEffect)(() => {
    if (listPrivileges.error != null) {
      setState({
        isAuthenticated: false,
        canManageIndex: false,
        canReadIndex: false,
        canWriteIndex: false
      });
    }
  }, [listPrivileges.error]);
  return {
    loading: listPrivileges.loading,
    ...state
  };
};
exports.useListsPrivileges = useListsPrivileges;