"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertTagsActions = void 0;
var _react = require("react");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _use_bulk_alert_tags_items = require("../../../../common/components/toolbar/bulk_actions/use_bulk_alert_tags_items");
var _use_alerts_privileges = require("../../../containers/detection_engine/alerts/use_alerts_privileges");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAlertTagsActions = ({
  closePopover,
  ecsRowData,
  refetch
}) => {
  var _ecsRowData$kibana2;
  const {
    hasIndexWrite
  } = (0, _use_alerts_privileges.useAlertsPrivileges)();
  const alertId = ecsRowData._id;
  const alertTagData = (0, _react.useMemo)(() => {
    var _ecsRowData$_index, _ecsRowData$kibana$al, _ecsRowData$kibana, _ecsRowData$_index2;
    return [{
      _id: alertId,
      _index: (_ecsRowData$_index = ecsRowData._index) !== null && _ecsRowData$_index !== void 0 ? _ecsRowData$_index : '',
      data: [{
        field: _ruleDataUtils.ALERT_WORKFLOW_TAGS,
        value: (_ecsRowData$kibana$al = ecsRowData === null || ecsRowData === void 0 ? void 0 : (_ecsRowData$kibana = ecsRowData.kibana) === null || _ecsRowData$kibana === void 0 ? void 0 : _ecsRowData$kibana.alert.workflow_tags) !== null && _ecsRowData$kibana$al !== void 0 ? _ecsRowData$kibana$al : []
      }],
      ecs: {
        _id: alertId,
        _index: (_ecsRowData$_index2 = ecsRowData._index) !== null && _ecsRowData$_index2 !== void 0 ? _ecsRowData$_index2 : ''
      }
    }];
  }, [alertId, ecsRowData._index, ecsRowData === null || ecsRowData === void 0 ? void 0 : (_ecsRowData$kibana2 = ecsRowData.kibana) === null || _ecsRowData$kibana2 === void 0 ? void 0 : _ecsRowData$kibana2.alert.workflow_tags]);
  const {
    alertTagsItems,
    alertTagsPanels
  } = (0, _use_bulk_alert_tags_items.useBulkAlertTagsItems)({
    refetch
  });
  const itemsToReturn = (0, _react.useMemo)(() => alertTagsItems.map(item => ({
    name: item.name,
    panel: item.panel,
    'data-test-subj': item['data-test-subj'],
    key: item.key
  })), [alertTagsItems]);
  const panelsToReturn = (0, _react.useMemo)(() => alertTagsPanels.map(panel => {
    const content = panel.renderContent({
      closePopoverMenu: closePopover,
      setIsBulkActionsLoading: () => {},
      alertItems: alertTagData
    });
    return {
      title: panel.title,
      content,
      id: panel.id
    };
  }), [alertTagData, alertTagsPanels, closePopover]);
  return {
    alertTagsItems: hasIndexWrite ? itemsToReturn : [],
    alertTagsPanels: panelsToReturn
  };
};
exports.useAlertTagsActions = useAlertTagsActions;