"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsProgressBarByHostNamePanel = exports.ALERTS_BY_HOST_ROW = exports.ALERTS_BY_HOST_PROGRESS_BAR = exports.ALERTS_BY_HOST_PANEL = exports.ALERTS_BY_HOST_NO_DATA = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _alerts_progress_bar_row = require("../../alerts_kpis/alerts_progress_bar_panel/alerts_progress_bar_row");
var _translations = require("../../alerts_kpis/alerts_progress_bar_panel/translations");
var _header_section = require("../../../../common/components/header_section");
var _inspect = require("../../../../common/components/inspect");
var _use_summary_chart_data = require("../../alerts_kpis/alerts_summary_charts_panel/use_summary_chart_data");
var _aggregations = require("../../alerts_kpis/alerts_summary_charts_panel/aggregations");
var _helpers = require("../../alerts_kpis/alerts_progress_bar_panel/helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERTS_BY_HOST_PANEL = exports.ALERTS_BY_HOST_PANEL = 'alert-summary-alerts-by-host-panel';
const ALERTS_BY_HOST_PROGRESS_BAR = exports.ALERTS_BY_HOST_PROGRESS_BAR = 'alert-summary-alerts-by-host-progress-bar';
const ALERTS_BY_HOST_ROW = exports.ALERTS_BY_HOST_ROW = 'alert-summary-alerts-by-host-row-';
const ALERTS_BY_HOST_NO_DATA = exports.ALERTS_BY_HOST_NO_DATA = 'alert-summary-alerts-by-host-no-data';
const ALERT_BY_HOST_NAME_TITLE = _i18n.i18n.translate('xpack.securitySolution.alertSummary.kpiSection.alertByHostNameTitle', {
  defaultMessage: 'Alert distribution by host'
});
const AGGREGATION_FIELD = 'host.name';
const AGGREGATION_NAME = 'Host name';
const TOP_ALERTS_CHART_ID = 'alerts-summary-top-alerts';
const HEIGHT = 160; // px

/**
 * Renders a list showing the percentages of alerts grouped by host.name .
 * The component is used in the alerts page in the AI for SOC alert summary page.
 */
const AlertsProgressBarByHostNamePanel = ({
  filters,
  query,
  signalIndexName,
  runtimeMappings,
  skip = false
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const uniqueQueryId = (0, _react.useMemo)(() => `${TOP_ALERTS_CHART_ID}-${(0, _uuid.v4)()}`, []);
  const aggregations = (0, _react.useMemo)(() => (0, _aggregations.alertsGroupingAggregations)(AGGREGATION_FIELD), []);
  const {
    items,
    isLoading
  } = (0, _use_summary_chart_data.useSummaryChartData)({
    aggregations,
    filters,
    query,
    signalIndexName,
    runtimeMappings,
    skip,
    uniqueQueryId
  });
  const data = (0, _react.useMemo)(() => (0, _helpers.getIsAlertsProgressBarData)(items) ? items : [], [items]);
  const [nonEmpty] = (0, _react.useMemo)(() => (0, _helpers.getAggregateData)(data), [data]);
  const noData = (0, _react.useMemo)(() => nonEmpty === 0, [nonEmpty]);
  return /*#__PURE__*/_react.default.createElement(_inspect.InspectButtonContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": ALERTS_BY_HOST_PANEL,
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    id: uniqueQueryId,
    inspectTitle: ALERT_BY_HOST_NAME_TITLE,
    outerDirection: "row",
    title: ALERT_BY_HOST_NAME_TITLE,
    titleSize: "xs",
    hideSubtitle: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    css: (0, _react2.css)`
            font-weight: ${euiTheme.font.weight.semiBold};
          `
  }, AGGREGATION_NAME), isLoading ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    "data-test-subj": ALERTS_BY_HOST_PROGRESS_BAR,
    color: "primary",
    size: "xs"
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }), noData ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": ALERTS_BY_HOST_NO_DATA,
    size: "s",
    textAlign: "center"
  }, _translations.EMPTY_DATA_MESSAGE) : /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-yScroll",
    css: (0, _react2.css)`
                  height: ${HEIGHT}px !important;
                `
  }, data.filter(item => item.key !== '-').map(item => /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `${ALERTS_BY_HOST_ROW}${item.key}`,
    key: `${item.key}`
  }, /*#__PURE__*/_react.default.createElement(_alerts_progress_bar_row.ProgressBarRow, {
    item: item
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })))))));
};
exports.AlertsProgressBarByHostNamePanel = AlertsProgressBarByHostNamePanel;
AlertsProgressBarByHostNamePanel.displayName = 'AlertsProgressBarByHostNamePanel';