"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRuleExecutionSettings = void 0;
var _react = require("react");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _kibana = require("../../../../common/lib/kibana");
var _constants = require("../../../../../common/constants");
var _rule_monitoring = require("../../../../../common/api/detection_engine/rule_monitoring");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useRuleExecutionSettings = () => {
  const featureFlagEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('extendedRuleExecutionLoggingEnabled');
  const advancedSettingEnabled = useAdvancedSettingSafely(_constants.EXTENDED_RULE_EXECUTION_LOGGING_ENABLED_SETTING, false);
  const advancedSettingMinLevel = useAdvancedSettingSafely(_constants.EXTENDED_RULE_EXECUTION_LOGGING_MIN_LEVEL_SETTING, _rule_monitoring.LogLevelSetting.off);
  return (0, _react.useMemo)(() => {
    return {
      extendedLogging: {
        isEnabled: featureFlagEnabled && advancedSettingEnabled,
        minLevel: advancedSettingMinLevel
      }
    };
  }, [featureFlagEnabled, advancedSettingEnabled, advancedSettingMinLevel]);
};
exports.useRuleExecutionSettings = useRuleExecutionSettings;
const useAdvancedSettingSafely = (key, defaultValue) => {
  try {
    const [value] = (0, _kibana.useUiSetting$)(key);
    return value;
  } catch (e) {
    // It throws when the setting is not registered (when featureFlagEnabled === false).
    return defaultValue;
  }
};